/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client;

import com.datastax.astra.client.DataAPIClient;
import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.admin.DataAPIDatabaseAdmin;
import com.datastax.astra.internal.auth.UsernamePasswordTokenProvider;
import com.datastax.astra.internal.command.LoggingCommandObserver;

public class DataAPIClients {
    public static final String DEFAULT_ENDPOINT_LOCAL = "http://localhost:8181";

    private DataAPIClients() {
    }

    public static DataAPIClient createForLocal() {
        return new DataAPIClient(new UsernamePasswordTokenProvider().getToken(), DataAPIOptions.builder().withDestination(DataAPIOptions.DataAPIDestination.CASSANDRA).withObserver(new LoggingCommandObserver(DataAPIClient.class)).build());
    }

    public static Database createDefaultLocalDatabase() {
        Database db = DataAPIClients.createForLocal().getDatabase(DEFAULT_ENDPOINT_LOCAL, "default_keyspace");
        DataAPIDatabaseAdmin dbAdmin = (DataAPIDatabaseAdmin)db.getDatabaseAdmin();
        dbAdmin.createNamespace("default_keyspace");
        return db;
    }

    public static DataAPIClient create(String token) {
        return new DataAPIClient(token, DataAPIOptions.builder().withDestination(DataAPIOptions.DataAPIDestination.ASTRA).build());
    }

    public static DataAPIClient createForAstraDev(String token) {
        return new DataAPIClient(token, DataAPIOptions.builder().withDestination(DataAPIOptions.DataAPIDestination.ASTRA_DEV).withObserver(new LoggingCommandObserver(DataAPIClient.class)).build());
    }

    public static DataAPIClient createForAstraTest(String token) {
        return new DataAPIClient(token, DataAPIOptions.builder().withDestination(DataAPIOptions.DataAPIDestination.ASTRA_TEST).build());
    }
}

