/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client;

import com.datastax.astra.client.DataAPIClient;
import com.datastax.astra.client.model.HttpClientOptions;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.command.LoggingCommandObserver;
import com.datastax.astra.internal.utils.Assert;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAPIOptions {
    private static final Logger log = LoggerFactory.getLogger(DataAPIOptions.class);
    public static final int DEFAULT_MAX_DOCUMENTS_COUNT = 1000;
    public static final int DEFAULT_MAX_PAGE_SIZE = 20;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 100;
    public static final String DEFAULT_CALLER_NAME = "astra-db-java";
    public static final String DEFAULT_CALLER_VERSION = DataAPIOptions.class.getPackage().getImplementationVersion() != null ? DataAPIOptions.class.getPackage().getImplementationVersion() : "dev";
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS_SECONDS = 20;
    public static final int DEFAULT_REQUEST_TIMEOUT_MILLIS_SECONDS = 20000;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final int DEFAULT_RETRY_DELAY_MILLIS = 100;
    public static final String DEFAULT_VERSION = "v1";
    final HttpClientOptions httpClientOptions;
    final DataAPIDestination destination;
    final String apiVersion;
    final int maxDocumentCount;
    final int maxPageSize;
    final int maxDocumentsInInsert;
    final String embeddingAPIKey;
    final Map<String, CommandObserver> observers;

    public static DataAPIClientOptionsBuilder builder() {
        return new DataAPIClientOptionsBuilder();
    }

    private DataAPIOptions(DataAPIClientOptionsBuilder builder) {
        this.apiVersion = builder.apiVersion;
        this.destination = builder.destination;
        this.maxDocumentCount = builder.maxDocumentCount;
        this.maxPageSize = builder.maxPageSize;
        this.maxDocumentsInInsert = builder.maxDocumentsInInsert;
        this.embeddingAPIKey = builder.embeddingAPIKey;
        this.httpClientOptions = new HttpClientOptions();
        this.observers = builder.observers;
        this.httpClientOptions.setHttpVersion(builder.httpVersion);
        this.httpClientOptions.setHttpRedirect(builder.httpRedirect);
        this.httpClientOptions.setRetryCount(builder.retryCount);
        this.httpClientOptions.setRetryDelay(builder.retryDelay);
        this.httpClientOptions.setUserAgentCallerName(builder.userAgentCallerName);
        this.httpClientOptions.setUserAgentCallerVersion(builder.userAgentCallerVersion);
        this.httpClientOptions.setConnectionRequestTimeoutInSeconds(builder.httpConnectTimeout);
        this.httpClientOptions.setMaxTimeMS(builder.maxTimeMS);
        this.httpClientOptions.setProxy(builder.httpProxy);
    }

    public HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public DataAPIDestination getDestination() {
        return this.destination;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public int getMaxDocumentCount() {
        return this.maxDocumentCount;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getMaxDocumentsInInsert() {
        return this.maxDocumentsInInsert;
    }

    public String getEmbeddingAPIKey() {
        return this.embeddingAPIKey;
    }

    public Map<String, CommandObserver> getObservers() {
        return this.observers;
    }

    public static class DataAPIClientOptionsBuilder {
        private String apiVersion = "v1";
        private String userAgentCallerName = "astra-db-java";
        private String userAgentCallerVersion = DEFAULT_CALLER_VERSION;
        private long maxTimeMS = 20L;
        private long httpConnectTimeout = 20000L;
        private int retryCount = 3;
        private int retryDelay = 100;
        private HttpProxy httpProxy;
        private HttpClient.Version httpVersion = HttpClient.Version.HTTP_1_1;
        private HttpClient.Redirect httpRedirect = HttpClient.Redirect.NORMAL;
        private DataAPIDestination destination = DataAPIDestination.ASTRA;
        private int maxDocumentCount = 1000;
        private int maxPageSize = 20;
        private int maxDocumentsInInsert = 100;
        private String embeddingAPIKey;
        private final Map<String, CommandObserver> observers = new TreeMap<String, CommandObserver>();

        public DataAPIClientOptionsBuilder withCaller(String callerName, String callerVersion) {
            Assert.hasLength(callerName, callerVersion);
            this.userAgentCallerName = callerName;
            this.userAgentCallerVersion = callerVersion;
            return this;
        }

        public DataAPIClientOptionsBuilder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DataAPIClientOptionsBuilder withHttpRedirect(HttpClient.Redirect redirect) {
            this.httpRedirect = redirect;
            return this;
        }

        public DataAPIClientOptionsBuilder withHtpVersion(HttpClient.Version version) {
            this.httpVersion = version;
            return this;
        }

        public DataAPIClientOptionsBuilder withHttpProxy(HttpProxy httpProxy) {
            this.httpProxy = httpProxy;
            return this;
        }

        public DataAPIClientOptionsBuilder withHttpRetryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public DataAPIClientOptionsBuilder withMaxTimeMS(long connectTimeout) {
            this.maxTimeMS = connectTimeout;
            return this;
        }

        public DataAPIClientOptionsBuilder withEmbeddingAPIKey(String embeddingAPIKey) {
            this.embeddingAPIKey = embeddingAPIKey;
            return this;
        }

        public DataAPIClientOptionsBuilder withHttpConnectTimeout(int requestTimeout) {
            this.httpConnectTimeout = requestTimeout;
            return this;
        }

        public DataAPIClientOptionsBuilder withDestination(DataAPIDestination destination) {
            this.destination = destination;
            return this;
        }

        public DataAPIClientOptionsBuilder withHttpRetryDelayMillis(int retryDelay) {
            if (retryDelay < 0) {
                throw new IllegalArgumentException("Retry delay must be non-negative");
            }
            this.retryDelay = retryDelay;
            return this;
        }

        public DataAPIClientOptionsBuilder withMaxDocumentCount(int maxDocumentCount) {
            if (maxDocumentCount <= 0) {
                throw new IllegalArgumentException("Max document count must be a positive number");
            }
            if (maxDocumentCount > 1000) {
                log.warn("Setting the maximum document count to a value greater than the default value of {} may impact performance.", (Object)1000);
            }
            this.maxDocumentCount = maxDocumentCount;
            return this;
        }

        public DataAPIClientOptionsBuilder withMaxPageSize(int maxPageSize) {
            if (maxPageSize <= 0) {
                throw new IllegalArgumentException("Max page size must be a positive number");
            }
            if (maxPageSize > 20) {
                log.warn("Setting the maximum page size to a value greater than the default value of {} may impact performance or result in error at server level", (Object)20);
            }
            this.maxPageSize = maxPageSize;
            return this;
        }

        public DataAPIClientOptionsBuilder withMaxDocumentsInInsert(int maxDocumentsInInsert) {
            if (maxDocumentsInInsert <= 0) {
                throw new IllegalArgumentException("Max documents in insert must be a positive number");
            }
            if (maxDocumentsInInsert > 100) {
                log.warn("Setting the maximum number of documents in insert to a value greater than the default value of {} may impact performance or result in error at server level", (Object)100);
            }
            this.maxDocumentsInInsert = maxDocumentsInInsert;
            return this;
        }

        public DataAPIClientOptionsBuilder withObserver(String name, CommandObserver observer) {
            this.observers.put(name, observer);
            return this;
        }

        public DataAPIClientOptionsBuilder withObserver(CommandObserver observer) {
            return this.withObserver(observer.getClass().getSimpleName(), observer);
        }

        public DataAPIClientOptionsBuilder logRequests() {
            return this.withObserver(new LoggingCommandObserver(DataAPIClient.class));
        }

        public DataAPIOptions build() {
            return new DataAPIOptions(this);
        }
    }

    public static enum DataAPIDestination {
        ASTRA,
        ASTRA_DEV,
        ASTRA_TEST,
        DSE,
        HCD,
        CASSANDRA,
        OTHERS;

    }

    public static class HttpProxy {
        String hostname;
        int port;

        public HttpProxy(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

