/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client;

import com.datastax.astra.client.Collection;
import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.admin.AstraDBDatabaseAdmin;
import com.datastax.astra.client.admin.DataAPIDatabaseAdmin;
import com.datastax.astra.client.admin.DatabaseAdmin;
import com.datastax.astra.client.model.CollectionInfo;
import com.datastax.astra.client.model.CollectionOptions;
import com.datastax.astra.client.model.Command;
import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.SimilarityMetric;
import com.datastax.astra.internal.api.AstraApiEndpoint;
import com.datastax.astra.internal.command.AbstractCommandRunner;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.utils.AnsiUtils;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.JsonUtils;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
extends AbstractCommandRunner {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final String namespaceName;
    private final String token;
    private final String apiEndpoint;
    private final DataAPIOptions options;
    private final String databaseAdminEndpoint;

    public Database(String apiEndpoint, String token) {
        this(apiEndpoint, token, "default_keyspace", DataAPIOptions.builder().build());
    }

    public Database(String apiEndpoint, String token, String namespace) {
        this(apiEndpoint, token, namespace, DataAPIOptions.builder().build());
    }

    public Database(String apiEndpoint, String token, String namespace, DataAPIOptions options) {
        Assert.hasLength(apiEndpoint, "endpoint");
        Assert.hasLength(token, "token");
        Assert.hasLength(namespace, "namespace");
        Assert.notNull(options, "options");
        this.namespaceName = namespace;
        this.token = token;
        this.options = options;
        this.databaseAdminEndpoint = apiEndpoint.endsWith(options.getApiVersion()) ? apiEndpoint : apiEndpoint + "/" + options.getApiVersion();
        StringBuilder dbApiEndPointBuilder = new StringBuilder(apiEndpoint);
        switch (options.destination) {
            case ASTRA: 
            case ASTRA_TEST: 
            case ASTRA_DEV: {
                if (!apiEndpoint.endsWith(".com")) break;
                dbApiEndPointBuilder.append("/api/json");
                break;
            }
        }
        this.apiEndpoint = dbApiEndPointBuilder.append("/").append(options.getApiVersion()).append("/").append(this.namespaceName).toString();
        this.commandOptions = ((CommandOptions)((CommandOptions)new CommandOptions().token(token)).embeddingAPIKey(options.getEmbeddingAPIKey())).httpClientOptions(options.getHttpClientOptions());
        options.getObservers().forEach(this.commandOptions::registerObserver);
    }

    public DatabaseAdmin getDatabaseAdmin() {
        return this.getDatabaseAdmin(this.token);
    }

    public DatabaseAdmin getDatabaseAdmin(String superUserToken) {
        if (Objects.requireNonNull(this.options.getDestination()) == DataAPIOptions.DataAPIDestination.ASTRA) {
            AstraApiEndpoint endpoint = AstraApiEndpoint.parse(this.apiEndpoint);
            return new AstraDBDatabaseAdmin(superUserToken, endpoint.getDatabaseId(), endpoint.getEnv(), this.options);
        }
        return new DataAPIDatabaseAdmin(this.databaseAdminEndpoint, this.token, this.options);
    }

    public Stream<String> listCollectionNames() {
        Command findCollections = Command.create("findCollections");
        return this.runCommand(findCollections).getStatusKeyAsList("collections", String.class).stream();
    }

    public Stream<CollectionInfo> listCollections() {
        Command findCollections = Command.create("findCollections").withOptions(new Document().append("explain", true));
        return this.runCommand(findCollections).getStatusKeyAsList("collections", CollectionInfo.class).stream();
    }

    public boolean collectionExists(String collection) {
        return this.listCollectionNames().anyMatch(collection::equals);
    }

    public Collection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    public <T> Collection<T> getCollection(String collectionName, @NonNull Class<T> documentClass) {
        if (documentClass == null) {
            throw new NullPointerException("documentClass is marked non-null but is null");
        }
        return this.getCollection(collectionName, null, documentClass);
    }

    public <T> Collection<T> getCollection(String collectionName, CommandOptions<?> commandOptions, @NonNull Class<T> documentClass) {
        if (documentClass == null) {
            throw new NullPointerException("documentClass is marked non-null but is null");
        }
        Assert.hasLength(collectionName, "collectionName");
        Assert.notNull(documentClass, "documentClass");
        Object collectionCollectionOptions = ((CommandOptions)((CommandOptions)new CommandOptions().token(this.token)).embeddingAPIKey(this.options.getEmbeddingAPIKey())).httpClientOptions(this.options.getHttpClientOptions());
        this.commandOptions.getObservers().forEach((arg_0, arg_1) -> collectionCollectionOptions.registerObserver(arg_0, arg_1));
        if (commandOptions != null) {
            commandOptions.getToken().ifPresent(arg_0 -> collectionCollectionOptions.token(arg_0));
            commandOptions.getEmbeddingAPIKey().ifPresent(arg_0 -> collectionCollectionOptions.embeddingAPIKey(arg_0));
            commandOptions.getHttpClientOptions().ifPresent(arg_0 -> collectionCollectionOptions.httpClientOptions(arg_0));
            commandOptions.getObservers().forEach((arg_0, arg_1) -> collectionCollectionOptions.registerObserver(arg_0, arg_1));
        }
        return new Collection<T>(this, collectionName, (CommandOptions<?>)collectionCollectionOptions, documentClass);
    }

    public void drop() {
        this.getDatabaseAdmin().dropNamespace(this.getNamespaceName());
    }

    public Collection<Document> createCollection(String collectionName) {
        return this.createCollection(collectionName, null, null, Document.class);
    }

    public Collection<Document> createCollection(String collectionName, int dimension, SimilarityMetric metric) {
        return this.createCollection(collectionName, dimension, metric, Document.class);
    }

    public <T> Collection<T> createCollection(String collectionName, int dimension, SimilarityMetric metric, Class<T> documentClass) {
        return this.createCollection(collectionName, CollectionOptions.builder().vectorDimension(dimension).vectorSimilarity(metric).build(), this.commandOptions, documentClass);
    }

    public <T> Collection<T> createCollection(String collectionName, Class<T> documentClass) {
        return this.createCollection(collectionName, null, this.commandOptions, documentClass);
    }

    public Collection<Document> createCollection(String collectionName, CollectionOptions collectionOptions) {
        return this.createCollection(collectionName, collectionOptions, this.commandOptions, Document.class);
    }

    public <T> Collection<T> createCollection(String collectionName, CollectionOptions collectionOptions, Class<T> documentClass) {
        return this.createCollection(collectionName, collectionOptions, this.commandOptions, documentClass);
    }

    public Collection<Document> createCollection(String collectionName, CollectionOptions collectionOptions, CommandOptions<?> commandOptions) {
        return this.createCollection(collectionName, collectionOptions, commandOptions, Document.class);
    }

    public <T> Collection<T> createCollection(String collectionName, CollectionOptions collectionOptions, CommandOptions<?> commandOptions, Class<T> documentClass) {
        Assert.hasLength(collectionName, "collectionName");
        Assert.notNull(documentClass, "documentClass");
        Command createCollection = Command.create("createCollection").append("name", collectionName);
        if (collectionOptions != null) {
            createCollection.withOptions(JsonUtils.convertValue(collectionOptions, Document.class));
        }
        this.runCommand(createCollection, commandOptions);
        log.info("Collection  '" + AnsiUtils.green("{}") + "' has been created", (Object)collectionName);
        return this.getCollection(collectionName, commandOptions, documentClass);
    }

    public void dropCollection(String collectionName) {
        this.runCommand(Command.create("deleteCollection").append("name", collectionName), this.commandOptions);
        log.info("Collection  '" + AnsiUtils.green("{}") + "' has been deleted", (Object)collectionName);
    }

    @Override
    protected String getApiEndpoint() {
        return this.apiEndpoint;
    }

    @Deprecated
    public void registerListener(String logger, CommandObserver commandObserver) {
        this.commandOptions.registerObserver(logger, commandObserver);
    }

    @Deprecated
    public void deleteListener(String name) {
        this.commandOptions.unregisterObserver(name);
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public DataAPIOptions getOptions() {
        return this.options;
    }
}

