/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.admin;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.admin.AstraDBDatabaseAdmin;
import com.datastax.astra.client.admin.DatabaseAdmin;
import com.datastax.astra.client.model.DatabaseInfo;
import com.datastax.astra.internal.api.AstraApiEndpoint;
import com.datastax.astra.internal.utils.AnsiUtils;
import com.datastax.astra.internal.utils.Assert;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.db.DbOpsClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;
import com.dtsx.astra.sdk.db.domain.DatabaseStatusType;
import com.dtsx.astra.sdk.db.exception.DatabaseNotFoundException;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.AstraRc;
import com.dtsx.astra.sdk.utils.Utils;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstraDBAdmin {
    private static final Logger log = LoggerFactory.getLogger(AstraDBAdmin.class);
    public static final CloudProviderType FREE_TIER_CLOUD = CloudProviderType.GCP;
    public static final String FREE_TIER_CLOUD_REGION = "us-east1";
    public static final String TOKEN_HEADER_PARAM = "X-Token";
    public static final String DEFAULT_NAMESPACE = "default_keyspace";
    final AstraDBOpsClient devopsDbClient;
    final DataAPIOptions dataAPIOptions;
    final AstraEnvironment env;
    final String token;
    final HttpClient httpClient;
    static String astraConfigToken;

    public AstraDBAdmin(String token, AstraEnvironment env, DataAPIOptions options) {
        Assert.hasLength(token, "token");
        Assert.notNull(env, "environment");
        Assert.notNull(options, "options");
        this.token = token;
        this.env = env;
        this.dataAPIOptions = options;
        this.devopsDbClient = new AstraDBOpsClient(token, this.env);
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        httpClientBuilder.version(options.getHttpClientOptions().getHttpVersion());
        httpClientBuilder.connectTimeout(Duration.ofSeconds(options.getHttpClientOptions().getConnectionRequestTimeoutInSeconds()));
        this.httpClient = httpClientBuilder.build();
    }

    public List<String> listDatabaseNames() {
        return this.listDatabases().stream().map(DatabaseInfo::getName).collect(Collectors.toList());
    }

    public List<DatabaseInfo> listDatabases() {
        return this.devopsDbClient.findAllNonTerminated().filter(db -> db.getInfo().getDbType() != null).map(DatabaseInfo::new).collect(Collectors.toList());
    }

    public boolean databaseExists(String name) {
        Assert.hasLength(name, "name");
        return this.listDatabaseNames().contains(name);
    }

    public boolean databaseExists(UUID id) {
        Assert.notNull(id, "id");
        return this.devopsDbClient.findById(id.toString()).isPresent();
    }

    public DatabaseAdmin createDatabase(String name) {
        Assert.hasLength(name, "name");
        return this.createDatabase(name, FREE_TIER_CLOUD, FREE_TIER_CLOUD_REGION);
    }

    public DatabaseAdmin createDatabase(String name, CloudProviderType cloud, String cloudRegion, boolean waitForDb) {
        Assert.hasLength(name, "name");
        Assert.notNull(cloud, "cloud");
        Assert.hasLength(cloudRegion, "cloudRegion");
        Optional<com.dtsx.astra.sdk.db.domain.Database> optDb = this.listDatabases().stream().filter(db -> name.equals(db.getName())).findFirst().map(DatabaseInfo::getRawDevopsResponse);
        if (optDb.isPresent()) {
            com.dtsx.astra.sdk.db.domain.Database db2 = optDb.get();
            switch (db2.getStatus()) {
                case ACTIVE: {
                    log.info("Database " + AnsiUtils.green("{}") + " already exists and is ACTIVE.", (Object)name);
                    return this.getDatabaseAdmin(UUID.fromString(db2.getId()));
                }
            }
            throw new IllegalStateException("Database already exists but is not in expected state.");
        }
        UUID newDbId = UUID.fromString(this.devopsDbClient.create(DatabaseCreationRequest.builder().name(name).cloudProvider(cloud).cloudRegion(cloudRegion).keyspace(DEFAULT_NAMESPACE).withVector().build()));
        log.info("Database {} is starting (id={}): it will take about a minute please wait...", (Object)name, (Object)newDbId);
        if (waitForDb) {
            this.waitForDatabase(this.devopsDbClient.database(newDbId.toString()));
        }
        return this.getDatabaseAdmin(newDbId);
    }

    public DatabaseAdmin createDatabase(String name, CloudProviderType cloud, String cloudRegion) {
        return this.createDatabase(name, cloud, cloudRegion, true);
    }

    public boolean dropDatabase(@NonNull UUID databaseId) {
        if (databaseId == null) {
            throw new NullPointerException("databaseId is marked non-null but is null");
        }
        Assert.notNull(databaseId, "Database identifier");
        boolean exists = this.databaseExists(databaseId);
        this.getDatabaseInfo(databaseId);
        this.devopsDbClient.database(databaseId.toString()).delete();
        return exists;
    }

    public boolean dropDatabase(@NonNull String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked non-null but is null");
        }
        Assert.hasLength(databaseName, "database");
        Assert.hasLength(databaseName, "Database ");
        Optional<DatabaseInfo> db = this.listDatabases().stream().filter(d -> d.getName().equals(databaseName)).findFirst();
        if (db.isPresent()) {
            this.devopsDbClient.database(db.get().getId().toString()).delete();
            return true;
        }
        return false;
    }

    public DatabaseInfo getDatabaseInfo(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Assert.notNull(id, "Database identifier should not be null");
        return new DatabaseInfo((com.dtsx.astra.sdk.db.domain.Database)this.devopsDbClient.findById(id.toString()).orElseThrow(() -> new DatabaseNotFoundException(id.toString())));
    }

    public Database getDatabase(UUID databaseId, String namespace) {
        Assert.notNull(databaseId, "databaseId");
        Assert.hasLength(namespace, "namespace");
        String databaseRegion = this.devopsDbClient.findById(databaseId.toString()).map(db -> db.getInfo().getRegion()).orElseThrow(() -> new DatabaseNotFoundException(databaseId.toString()));
        return new Database(new AstraApiEndpoint(databaseId, databaseRegion, this.env).getApiEndPoint(), this.token, namespace, this.dataAPIOptions){};
    }

    public Database getDatabase(UUID databaseId) {
        return this.getDatabase(databaseId, DEFAULT_NAMESPACE);
    }

    public AstraDBDatabaseAdmin getDatabaseAdmin(UUID databaseId) {
        Assert.notNull(databaseId, "databaseId");
        return new AstraDBDatabaseAdmin(this.token, databaseId, this.env, this.dataAPIOptions);
    }

    private void waitForDatabase(DbOpsClient dbc) {
        long top = System.currentTimeMillis();
        while (DatabaseStatusType.ACTIVE != this.getStatus(dbc) && System.currentTimeMillis() - top < 180000L) {
            try {
                Thread.sleep(5000L);
                log.info("\u25a0");
            }
            catch (InterruptedException e) {
                log.warn("Interrupted {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        if (this.getStatus(dbc) != DatabaseStatusType.ACTIVE) {
            throw new IllegalStateException("Database is not in expected state after timeouts");
        }
    }

    private DatabaseStatusType getStatus(DbOpsClient dbc) {
        return ((com.dtsx.astra.sdk.db.domain.Database)dbc.find().orElseThrow(() -> new DatabaseNotFoundException(dbc.getDatabaseId()))).getStatus();
    }

    static {
        new AstraRc().getSectionKey("default", "ASTRA_DB_APPLICATION_TOKEN").ifPresent(s -> {
            astraConfigToken = s;
        });
        Utils.readEnvVariable((String)"ASTRA_DB_APPLICATION_TOKEN").ifPresent(s -> {
            astraConfigToken = s;
        });
    }
}

