/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.admin;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.admin.DataAPIDatabaseAdmin;
import com.datastax.astra.client.admin.DatabaseAdmin;
import com.datastax.astra.client.model.EmbeddingProvider;
import com.datastax.astra.internal.api.AstraApiEndpoint;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.db.exception.DatabaseNotFoundException;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AstraDBDatabaseAdmin
implements DatabaseAdmin {
    final String token;
    final UUID databaseId;
    final AstraEnvironment env;
    final DataAPIOptions options;
    final AstraDBOpsClient devopsDbClient;

    public AstraDBDatabaseAdmin(String token, UUID databaseId, AstraEnvironment env, DataAPIOptions options) {
        this.env = env;
        this.token = token;
        this.databaseId = databaseId;
        this.options = options;
        this.devopsDbClient = new AstraDBOpsClient(token, this.env);
    }

    public com.dtsx.astra.sdk.db.domain.Database getDatabaseInformations() {
        return (com.dtsx.astra.sdk.db.domain.Database)this.devopsDbClient.findById(this.databaseId.toString()).orElseThrow(() -> new DatabaseNotFoundException(this.databaseId.toString()));
    }

    private String getApiEndpoint() {
        return new AstraApiEndpoint(this.databaseId, this.getDatabaseInformations().getInfo().getRegion(), this.env).getApiEndPoint();
    }

    @Override
    public Database getDatabase(String namespaceName) {
        return this.getDatabase(namespaceName, this.token);
    }

    @Override
    public Database getDatabase(String namespaceName, String tokenUser) {
        return new Database(this.getApiEndpoint(), tokenUser, namespaceName);
    }

    @Override
    public Set<String> listNamespaceNames() {
        return this.devopsDbClient.database(this.databaseId.toString()).keyspaces().findAll();
    }

    @Override
    public Map<String, EmbeddingProvider> listEmbeddingProviders() {
        return new DataAPIDatabaseAdmin(this.getApiEndpoint() + "/" + this.options.getApiVersion(), this.token, this.options).listEmbeddingProviders();
    }

    @Override
    public void createNamespace(String namespace) {
        this.devopsDbClient.database(this.databaseId.toString()).keyspaces().create(namespace);
    }

    @Override
    public void dropNamespace(String namespace) {
        try {
            this.devopsDbClient.database(this.databaseId.toString()).keyspaces().delete(namespace);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

