/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.admin;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.admin.DatabaseAdmin;
import com.datastax.astra.client.model.Command;
import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.EmbeddingProvider;
import com.datastax.astra.client.model.NamespaceOptions;
import com.datastax.astra.internal.command.AbstractCommandRunner;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.utils.AnsiUtils;
import com.datastax.astra.internal.utils.Assert;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAPIDatabaseAdmin
extends AbstractCommandRunner
implements DatabaseAdmin {
    private static final Logger log = LoggerFactory.getLogger(DataAPIDatabaseAdmin.class);
    private static final String ARG_NAMESPACE = "namespaceName";
    protected final DataAPIOptions options;
    protected final String apiEndPoint;
    protected final String token;

    public DataAPIDatabaseAdmin(String apiEndpoint, String token, DataAPIOptions options) {
        this.apiEndPoint = apiEndpoint;
        this.token = token;
        this.options = options;
        this.commandOptions = ((CommandOptions)((CommandOptions)new CommandOptions().token(token)).embeddingAPIKey(options.getEmbeddingAPIKey())).httpClientOptions(options.getHttpClientOptions());
        options.getObservers().forEach(this.commandOptions::registerObserver);
    }

    @Override
    public Set<String> listNamespaceNames() {
        Command cmd = Command.create("findNamespaces");
        return this.runCommand(cmd).getStatusKeyAsStringStream("namespaces").collect(Collectors.toSet());
    }

    @Override
    public Map<String, EmbeddingProvider> listEmbeddingProviders() {
        return this.runCommand(Command.create("findEmbeddingProviders")).getStatusKeyAsMap("embeddingProviders", EmbeddingProvider.class);
    }

    @Override
    public Database getDatabase(String namespaceName) {
        Assert.hasLength(namespaceName, ARG_NAMESPACE);
        return new Database(this.apiEndPoint, this.token, namespaceName, this.options);
    }

    @Override
    public Database getDatabase(String namespaceName, String userToken) {
        Assert.hasLength(namespaceName, ARG_NAMESPACE);
        Assert.hasLength(userToken, "userToken");
        return new Database(this.apiEndPoint, userToken, namespaceName, this.options);
    }

    @Override
    public void createNamespace(String namespace) {
        Assert.hasLength(namespace, ARG_NAMESPACE);
        this.createNamespace(namespace, NamespaceOptions.simpleStrategy(1));
    }

    public void createNamespace(String namespace, NamespaceOptions options) {
        Assert.hasLength(namespace, ARG_NAMESPACE);
        Assert.notNull(options, "options");
        Command createNamespace = Command.create("createNamespace").append("name", namespace).withOptions(options);
        this.runCommand(createNamespace);
        log.info("Namespace  '" + AnsiUtils.green("{}") + "' has been created", (Object)namespace);
    }

    @Override
    public void dropNamespace(String namespace) {
        Assert.hasLength(namespace, ARG_NAMESPACE);
        Command dropNamespace = Command.create("dropNamespace").append("name", namespace);
        this.runCommand(dropNamespace);
        log.info("Namespace  '" + AnsiUtils.green("{}") + "' has been deleted", (Object)namespace);
    }

    @Override
    protected String getApiEndpoint() {
        return this.apiEndPoint;
    }

    @Deprecated
    public void registerListener(String logger, CommandObserver commandObserver) {
        this.commandOptions.registerObserver(logger, commandObserver);
    }

    @Deprecated
    public void deleteListener(String name) {
        this.commandOptions.unregisterObserver(name);
    }

    public DataAPIOptions getOptions() {
        return this.options;
    }

    public String getToken() {
        return this.token;
    }
}

