/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.admin;

import com.datastax.astra.client.Database;
import com.datastax.astra.client.model.EmbeddingProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface DatabaseAdmin {
    public Set<String> listNamespaceNames();

    public Map<String, EmbeddingProvider> listEmbeddingProviders();

    default public CompletableFuture<Set<String>> listNamespaceNamesAsync() {
        return CompletableFuture.supplyAsync(this::listNamespaceNames);
    }

    public Database getDatabase(String var1);

    public Database getDatabase(String var1, String var2);

    default public Database getDatabase() {
        return this.getDatabase("default_keyspace");
    }

    public void dropNamespace(String var1);

    default public void dropNamespaceAsync(String namespace) {
        CompletableFuture.runAsync(() -> this.dropNamespace(namespace));
    }

    public void createNamespace(String var1);

    default public CompletableFuture<Void> createNamespaceAsync(String namespace) {
        return CompletableFuture.runAsync(() -> this.createNamespace(namespace));
    }

    default public boolean namespaceExists(String namespace) {
        return this.listNamespaceNames().contains(namespace);
    }
}

