/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.exception;

import com.datastax.astra.client.exception.DataApiException;
import com.datastax.astra.internal.api.ApiError;
import com.datastax.astra.internal.api.ApiResponse;
import com.datastax.astra.internal.command.ExecutionInfos;
import com.datastax.astra.internal.utils.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DataApiResponseException
extends DataApiException {
    private final transient List<ExecutionInfos> commandsList;

    public DataApiResponseException(List<ExecutionInfos> cmdList) {
        super(DataApiResponseException.getErrorCode(cmdList), DataApiResponseException.getErrorMessage(cmdList));
        this.commandsList = cmdList;
    }

    public List<ApiError> getApiErrors() {
        return this.commandsList.stream().map(ExecutionInfos::getResponse).filter(Objects::nonNull).map(ApiResponse::getErrors).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static String getErrorMessage(List<ExecutionInfos> commands) {
        Assert.notNull(commands, "commandList");
        return DataApiResponseException.findFirstError(commands).map(ApiError::getErrorMessage).orElse("Unexpected error occurred for Data API");
    }

    public static String getErrorCode(List<ExecutionInfos> commands) {
        Assert.notNull(commands, "commandList");
        return DataApiResponseException.findFirstError(commands).map(ApiError::getErrorCode).orElse("CLIENT_ERROR");
    }

    private static Optional<ApiError> findFirstError(List<ExecutionInfos> commands) {
        for (ExecutionInfos command : commands) {
            if (command.getResponse() == null || command.getResponse().getErrors() == null || command.getResponse().getErrors().isEmpty()) continue;
            return Optional.ofNullable(command.getResponse().getErrors().get(0));
        }
        return Optional.empty();
    }

    public List<ExecutionInfos> getCommandsList() {
        return this.commandsList;
    }
}

