/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CollectionIdTypes;
import com.datastax.astra.client.model.SimilarityMetric;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CollectionOptions {
    private DefaultIdOptions defaultId;
    private VectorOptions vector;
    private IndexingOptions indexing;

    public static CollectionOptionsBuilder builder() {
        return new CollectionOptionsBuilder();
    }

    public DefaultIdOptions getDefaultId() {
        return this.defaultId;
    }

    public VectorOptions getVector() {
        return this.vector;
    }

    public IndexingOptions getIndexing() {
        return this.indexing;
    }

    public void setDefaultId(DefaultIdOptions defaultId) {
        this.defaultId = defaultId;
    }

    public void setVector(VectorOptions vector) {
        this.vector = vector;
    }

    public void setIndexing(IndexingOptions indexing) {
        this.indexing = indexing;
    }

    public static class CollectionOptionsBuilder {
        VectorOptions vector;
        IndexingOptions indexing;
        String defaultId;

        private VectorOptions getVector() {
            if (this.vector == null) {
                this.vector = new VectorOptions();
            }
            return this.vector;
        }

        private IndexingOptions getIndexing() {
            if (this.indexing == null) {
                this.indexing = new IndexingOptions();
            }
            return this.indexing;
        }

        public CollectionOptionsBuilder defaultIdType(CollectionIdTypes idType) {
            this.defaultId = idType.getValue();
            return this;
        }

        public CollectionOptionsBuilder vectorDimension(int size) {
            this.getVector().setDimension(size);
            return this;
        }

        public CollectionOptionsBuilder vectorSimilarity(@NonNull SimilarityMetric function) {
            if (function == null) {
                throw new NullPointerException("function is marked non-null but is null");
            }
            this.getVector().setMetric(function.getValue());
            return this;
        }

        public CollectionOptionsBuilder indexingDeny(String ... properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            if (this.getIndexing().getAllow() != null) {
                throw new IllegalStateException("'indexing.deny' and 'indexing.allow' are mutually exclusive");
            }
            this.getIndexing().setDeny(Arrays.asList(properties));
            return this;
        }

        public CollectionOptionsBuilder indexingAllow(String ... properties) {
            if (this.getIndexing().getDeny() != null) {
                throw new IllegalStateException("'indexing.deny' and 'indexing.allow' are mutually exclusive");
            }
            this.getIndexing().setAllow(Arrays.asList(properties));
            return this;
        }

        public CollectionOptionsBuilder vector(int dimension, @NonNull SimilarityMetric function) {
            if (function == null) {
                throw new NullPointerException("function is marked non-null but is null");
            }
            this.vectorSimilarity(function);
            this.vectorDimension(dimension);
            return this;
        }

        public CollectionOptionsBuilder vectorize(String provider, String modeName) {
            return this.vectorize(provider, modeName, null);
        }

        public CollectionOptionsBuilder vectorize(String provider, String modeName, String keyName) {
            Service embeddingService = new Service();
            embeddingService.setProvider(provider);
            embeddingService.setModelName(modeName);
            if (keyName != null) {
                embeddingService.setAuthentication(Map.of("providerKey", keyName + ".providerKey"));
            }
            this.getVector().setService(embeddingService);
            return this;
        }

        public CollectionOptionsBuilder vectorize(String provider, String modeName, String keyName, Map<String, Object> parameters) {
            this.vectorize(provider, modeName, keyName);
            this.getVector().getService().setParameters(parameters);
            return this;
        }

        public CollectionOptions build() {
            CollectionOptions req = new CollectionOptions();
            req.vector = this.vector;
            req.indexing = this.indexing;
            if (this.defaultId != null) {
                req.defaultId = new DefaultIdOptions(this.defaultId);
            }
            return req;
        }
    }

    public static class DefaultIdOptions {
        private String type;

        public DefaultIdOptions() {
        }

        public DefaultIdOptions(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class VectorOptions {
        private Integer dimension;
        private String metric;
        private Service service;

        @JsonIgnore
        public SimilarityMetric getSimilarityMetric() {
            return SimilarityMetric.fromValue(this.metric);
        }

        public Integer getDimension() {
            return this.dimension;
        }

        public String getMetric() {
            return this.metric;
        }

        public Service getService() {
            return this.service;
        }

        public void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public void setService(Service service) {
            this.service = service;
        }
    }

    public static class IndexingOptions {
        private List<String> deny;
        private List<String> allow;

        public List<String> getDeny() {
            return this.deny;
        }

        public List<String> getAllow() {
            return this.allow;
        }

        public void setDeny(List<String> deny) {
            this.deny = deny;
        }

        public void setAllow(List<String> allow) {
            this.allow = allow;
        }
    }

    public static class Parameters {
        private String type;
        private boolean required;
        @JsonProperty(value="default")
        private Object defaultValue;
        private String help;

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getHelp() {
            return this.help;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        @JsonProperty(value="default")
        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setHelp(String help) {
            this.help = help;
        }
    }

    public static class Service {
        private String provider;
        private String modelName;
        private Map<String, Object> authentication;
        private Map<String, Object> parameters;

        public String getProvider() {
            return this.provider;
        }

        public String getModelName() {
            return this.modelName;
        }

        public Map<String, Object> getAuthentication() {
            return this.authentication;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public void setAuthentication(Map<String, Object> authentication) {
            this.authentication = authentication;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
        }
    }
}

