/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.Update;
import com.datastax.astra.internal.utils.Assert;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=CommandSerializer.class)
public class Command
implements Serializable {
    protected String name;
    protected Document payload = new Document();

    public Command() {
    }

    public static Command create(String name) {
        return new Command(name);
    }

    public Command(String name) {
        Assert.hasLength(name, "command name");
        this.name = name;
    }

    public Command withFilter(Filter filter) {
        this.payload.appendIfNotNull("filter", filter);
        return this;
    }

    public Command withReplacement(Object replacement) {
        this.payload.appendIfNotNull("replacement", replacement);
        return this;
    }

    public Command withProjection(Map<String, Object> projection) {
        this.payload.appendIfNotNull("projection", projection);
        return this;
    }

    public Command withSort(Document sort) {
        this.payload.appendIfNotNull("sort", sort);
        return this;
    }

    public Command withOptions(Object options) {
        this.payload.appendIfNotNull("options", options);
        return this;
    }

    public Command withDocument(Object document) {
        this.payload.appendIfNotNull("document", document);
        return this;
    }

    public <T> Command withDocuments(List<T> documents) {
        this.payload.appendIfNotNull("documents", documents);
        return this;
    }

    public Command append(String key, Object obj) {
        this.payload.appendIfNotNull(key, obj);
        return this;
    }

    public Command withUpdate(Update update) {
        this.payload.appendIfNotNull("update", update);
        return this;
    }

    public Command(String name, Document payload) {
        this.name = name;
        this.payload = payload;
    }

    public String getName() {
        return this.name;
    }

    public Document getPayload() {
        return this.payload;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPayload(Document payload) {
        this.payload = payload;
    }

    public static class CommandSerializer
    extends StdSerializer<Command> {
        public CommandSerializer() {
            this(null);
        }

        public CommandSerializer(Class<Command> clazz) {
            super(clazz);
        }

        public void serialize(Command command, JsonGenerator gen, SerializerProvider provider) throws IOException {
            LinkedHashMap<String, Document> commandMap = new LinkedHashMap<String, Document>();
            commandMap.put(command.getName(), command.getPayload());
            gen.writeObject(commandMap);
        }
    }
}

