/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.HttpClientOptions;
import com.datastax.astra.internal.command.CommandObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class CommandOptions<T extends CommandOptions<T>> {
    protected Map<String, CommandObserver> observers = new LinkedHashMap<String, CommandObserver>();
    protected String token;
    protected HttpClientOptions httpClientOptions;
    protected String embeddingAPIKey;

    public T token(String token) {
        this.token = token;
        return (T)this;
    }

    public T httpClientOptions(HttpClientOptions options) {
        this.httpClientOptions = options;
        return (T)this;
    }

    public T embeddingAPIKey(String embeddingServiceApiKey) {
        this.embeddingAPIKey = embeddingServiceApiKey;
        return (T)this;
    }

    public T registerObserver(String name, CommandObserver observer) {
        if (observer != null) {
            this.observers.put(name, observer);
        }
        return (T)this;
    }

    public T registerObserver(CommandObserver observer) {
        return this.registerObserver(observer.getClass().getSimpleName(), observer);
    }

    public T unregisterObserver(String name) {
        this.observers.remove(name);
        return (T)this;
    }

    public T unregisterObserver(Class<CommandObserver> observer) {
        return this.unregisterObserver(observer.getSimpleName());
    }

    public Optional<String> getEmbeddingAPIKey() {
        return Optional.ofNullable(this.embeddingAPIKey);
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public Optional<HttpClientOptions> getHttpClientOptions() {
        return Optional.ofNullable(this.httpClientOptions);
    }

    public Map<String, CommandObserver> getObservers() {
        return this.observers;
    }
}

