/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.internal.utils.Assert;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.Datacenter;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class DatabaseInfo {
    private UUID id;
    private String name;
    private CloudProviderType cloud;
    private String region;
    private String namespace;
    private String namespaceList;
    private Set<String> regionList;
    private String creationTime;
    private Database rawDevopsResponse;

    public DatabaseInfo(Database db) {
        Assert.notNull(db, "Database");
        this.rawDevopsResponse = db;
        this.id = UUID.fromString(db.getId());
        this.name = db.getInfo().getName();
        this.namespace = db.getInfo().getKeyspace();
        this.region = db.getInfo().getRegion();
        this.cloud = db.getInfo().getCloudProvider();
        this.creationTime = db.getCreationTime();
        this.regionList = db.getInfo().getDatacenters().stream().map(Datacenter::getRegion).collect(Collectors.toSet());
        this.namespaceList = String.join((CharSequence)",", db.getInfo().getKeyspaces());
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CloudProviderType getCloud() {
        return this.cloud;
    }

    public String getRegion() {
        return this.region;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceList() {
        return this.namespaceList;
    }

    public Set<String> getRegionList() {
        return this.regionList;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public Database getRawDevopsResponse() {
        return this.rawDevopsResponse;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCloud(CloudProviderType cloud) {
        this.cloud = cloud;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setNamespaceList(String namespaceList) {
        this.namespaceList = namespaceList;
    }

    public void setRegionList(Set<String> regionList) {
        this.regionList = regionList;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public void setRawDevopsResponse(Database rawDevopsResponse) {
        this.rawDevopsResponse = rawDevopsResponse;
    }
}

