/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.Collection;
import com.datastax.astra.client.model.DistinctIterator;
import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.FindOptions;
import com.datastax.astra.client.model.PageableIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctIterable<T, F>
extends PageableIterable<T>
implements Iterable<F> {
    private static final Logger log = LoggerFactory.getLogger(DistinctIterable.class);
    private final String fieldName;
    private final Class<F> fieldClass;
    protected DistinctIterator<T, F> currentPageIterator;

    public DistinctIterable(Collection<T> collection, String fieldName, Filter filter, Class<F> fieldClass) {
        this.collection = collection;
        this.filter = filter;
        this.fieldName = fieldName;
        this.fieldClass = fieldClass;
        this.options = new FindOptions();
    }

    @NonNull
    public DistinctIterator<T, F> iterator() {
        if (this.currentPageIterator == null) {
            this.active = this.fetchNextPage();
            this.currentPageIterator = new DistinctIterator(this, this.fieldName, this.fieldClass);
        }
        return this.currentPageIterator;
    }

    public List<F> all() {
        if (this.exhausted) {
            throw new IllegalStateException("Iterable is already exhausted.");
        }
        if (this.active) {
            throw new IllegalStateException("Iterable has already been started");
        }
        ArrayList results = new ArrayList();
        try {
            for (Object fieldValue : this) {
                results.add(fieldValue);
            }
        }
        catch (NoSuchElementException e) {
            log.warn("Last page was empty");
        }
        return results;
    }
}

