/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.PageableIterable;
import com.datastax.astra.internal.utils.JsonUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctIterator<T, F>
implements Iterator<F> {
    private static final Logger log = LoggerFactory.getLogger(DistinctIterator.class);
    private final PageableIterable<T> parentIterable;
    private Iterator<F> resultsIterator;
    private final String fieldName;
    private final Class<F> fieldClass;
    private Set<F> currentPageRecords;
    private final Set<F> existingValues = new HashSet<F>();

    public DistinctIterator(PageableIterable<T> findIterable, String fieldName, Class<F> fieldClass) {
        this.parentIterable = findIterable;
        this.fieldName = fieldName;
        this.fieldClass = fieldClass;
        this.initResultIterator();
    }

    private F extractField(T t) {
        return JsonUtils.convertValue(t, Document.class).get(this.fieldName, this.fieldClass);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        boolean bl = hasNext = this.resultsIterator.hasNext() || this.parentIterable.getCurrentPage().getPageState().isPresent();
        if (!hasNext) {
            this.parentIterable.close();
        }
        return hasNext;
    }

    @Override
    public F next() {
        if (this.resultsIterator.hasNext()) {
            this.parentIterable.getTotalItemProcessed().incrementAndGet();
            F nextValue = this.resultsIterator.next();
            this.existingValues.add(nextValue);
            return nextValue;
        }
        if (this.parentIterable.getCurrentPage().getPageState().isPresent()) {
            this.parentIterable.fetchNextPage();
            this.initResultIterator();
            if (this.currentPageRecords.isEmpty()) {
                log.warn("Last page is empty after deduplication => NoSuchElementException");
            }
            return this.next();
        }
        this.parentIterable.close();
        throw new NoSuchElementException("End of the collection");
    }

    private void initResultIterator() {
        this.currentPageRecords = new LinkedHashSet<F>();
        this.currentPageRecords.addAll(this.parentIterable.getCurrentPage().getResults().stream().map(this::extractField).collect(Collectors.toList()));
        this.currentPageRecords.removeAll(this.existingValues);
        this.resultsIterator = this.currentPageRecords.iterator();
    }
}

