/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.DataAPIKeywords;
import com.datastax.astra.client.model.ObjectId;
import com.datastax.astra.internal.utils.JsonUtils;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;

public class Document
implements Map<String, Object>,
Serializable {
    @JsonUnwrapped
    public transient Map<String, Object> documentMap;

    public Document() {
        this.documentMap = new LinkedHashMap<String, Object>();
    }

    public Document(Object id) {
        this();
        this.id(id);
    }

    public static Document create(Object id) {
        return new Document(id);
    }

    public static Document create() {
        return new Document();
    }

    public <T> T map(Class<T> clazz) {
        return JsonUtils.convertValue(this.documentMap, clazz);
    }

    public Document(Map<String, ?> map) {
        this.documentMap = new LinkedHashMap(map);
    }

    public static Document parse(String json) {
        return new Document(JsonUtils.unMarshallBean(json, LinkedHashMap.class));
    }

    public Document append(String key, Object value) {
        this.documentMap.put(key, value);
        return this;
    }

    public Document appendIfNotNull(String key, Object value) {
        if (value != null) {
            return this.append(key, value);
        }
        return this;
    }

    public <T> T get(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return clazz.cast(JsonUtils.convertValue(this.documentMap.get(key), clazz));
    }

    public <T> T getId(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.get(DataAPIKeywords.ID.getKeyword(), clazz);
    }

    public <T> Document id(T id) {
        return this.appendIfNotNull(DataAPIKeywords.ID.getKeyword(), id);
    }

    public Document vectorize(String text) {
        return this.appendIfNotNull(DataAPIKeywords.VECTORIZE.getKeyword(), text);
    }

    public Optional<String> getVectorize() {
        return Optional.ofNullable(this.get(DataAPIKeywords.VECTORIZE.getKeyword(), String.class));
    }

    public Optional<float[]> getVector() {
        return Optional.ofNullable(this.get(DataAPIKeywords.VECTOR.getKeyword(), float[].class));
    }

    public Document vector(float[] vector) {
        return this.append(DataAPIKeywords.VECTOR.getKeyword(), vector);
    }

    public Optional<Double> getSimilarity() {
        return Optional.ofNullable(this.get(DataAPIKeywords.SIMILARITY.getKeyword(), Double.class));
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        Object o = this.get(key);
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Date getDate(Object key) {
        return (Date)this.get(key);
    }

    public <K> K[] getArray(String k, Class<K> itemClass) {
        List<K> list = this.getList(k, itemClass);
        Object[] array = (Object[])Array.newInstance(itemClass, list.size());
        return list.toArray(array);
    }

    public ObjectId getObjectId(String k) {
        Object o = this.get(k);
        if (o == null) {
            return null;
        }
        if (!(o instanceof LinkedHashMap)) {
            throw new IllegalArgumentException("UUID must be a string or a map with a $objectId key but found " + String.valueOf(o));
        }
        LinkedHashMap map = (LinkedHashMap)o;
        if (!map.containsKey(DataAPIKeywords.OBJECT_ID.getKeyword())) {
            throw new IllegalArgumentException("UUID must be a string or a map with a $objectId key but found " + String.valueOf(o));
        }
        return new ObjectId((String)map.get(DataAPIKeywords.OBJECT_ID.getKeyword()));
    }

    public UUID getUUID(String k) {
        Object o = this.get(k);
        if (o == null) {
            return null;
        }
        if (!(o instanceof LinkedHashMap)) {
            throw new IllegalArgumentException("UUID must be a string or a map with a $uuid key but found " + String.valueOf(o));
        }
        LinkedHashMap map = (LinkedHashMap)o;
        if (!map.containsKey(DataAPIKeywords.UUID.getKeyword())) {
            throw new IllegalArgumentException("UUID must be a string or a map with a $uuid key but found " + String.valueOf(o));
        }
        return UUID.fromString((String)map.get(DataAPIKeywords.UUID.getKeyword()));
    }

    public Float getFloat(String k) {
        return this.get(k, Float.class);
    }

    public Short getShort(String k) {
        return this.get(k, Short.class);
    }

    public Byte getByte(String k) {
        return this.get(k, Byte.class);
    }

    public Character getCharacter(String k) {
        return this.get(k, Character.class);
    }

    public Date getDate(String k) {
        return this.get(k, Date.class);
    }

    public Calendar getCalendar(String k) {
        return this.get(k, Calendar.class);
    }

    public Instant getInstant(String k) {
        return this.get(k, Instant.class);
    }

    public <T> List<T> getList(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.constructValuesList(key, clazz, null);
    }

    public <T> List<T> getList(String key, Class<T> clazz, List<T> defaultValue) {
        return this.constructValuesList(key, clazz, defaultValue);
    }

    private <T> List<T> constructValuesList(String key, Class<T> clazz, List<T> defaultValue) {
        List value = this.get(key, List.class);
        if (value == null) {
            return defaultValue;
        }
        for (Object item : value) {
            if (item == null || clazz.isAssignableFrom(item.getClass())) continue;
            throw new ClassCastException(String.format("List element cannot be cast to %s", clazz.getName()));
        }
        return value;
    }

    public String toString() {
        return JsonUtils.marshall(this.documentMap);
    }

    public String toJson() {
        return this.toString();
    }

    @Override
    public int size() {
        return this.documentMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.documentMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.documentMap.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.documentMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.documentMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.documentMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.documentMap.putAll(map);
    }

    @Override
    public void clear() {
        this.documentMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.documentMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return this.documentMap.equals(document.documentMap);
    }

    @Override
    public int hashCode() {
        return this.documentMap.hashCode();
    }
}

