/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EmbeddingProvider {
    public static final String AUTHENTICATION_METHOD_NONE = "NONE";
    public static final String AUTHENTICATION_METHOD_SHARED_SECRET = "SHARED_SECRET";
    public static final String AUTHENTICATION_METHOD_HEADER = "HEADER";
    private String displayName;
    private String url;
    private Map<String, AuthenticationMethod> supportedAuthentication;
    private List<Parameter> parameters;
    private List<Model> models;

    public Optional<AuthenticationMethod> getSharedSecretAuthentication() {
        return Optional.ofNullable(this.supportedAuthentication.get(AUTHENTICATION_METHOD_SHARED_SECRET));
    }

    public Optional<AuthenticationMethod> getHeaderAuthentication() {
        return Optional.ofNullable(this.supportedAuthentication.get(AUTHENTICATION_METHOD_HEADER));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, AuthenticationMethod> getSupportedAuthentication() {
        return this.supportedAuthentication;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSupportedAuthentication(Map<String, AuthenticationMethod> supportedAuthentication) {
        this.supportedAuthentication = supportedAuthentication;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setModels(List<Model> models) {
        this.models = models;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingProvider)) {
            return false;
        }
        EmbeddingProvider other = (EmbeddingProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, AuthenticationMethod> this$supportedAuthentication = this.getSupportedAuthentication();
        Map<String, AuthenticationMethod> other$supportedAuthentication = other.getSupportedAuthentication();
        if (this$supportedAuthentication == null ? other$supportedAuthentication != null : !((Object)this$supportedAuthentication).equals(other$supportedAuthentication)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<Model> this$models = this.getModels();
        List<Model> other$models = other.getModels();
        return !(this$models == null ? other$models != null : !((Object)this$models).equals(other$models));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, AuthenticationMethod> $supportedAuthentication = this.getSupportedAuthentication();
        result = result * 59 + ($supportedAuthentication == null ? 43 : ((Object)$supportedAuthentication).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<Model> $models = this.getModels();
        result = result * 59 + ($models == null ? 43 : ((Object)$models).hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingProvider(displayName=" + this.getDisplayName() + ", url=" + this.getUrl() + ", supportedAuthentication=" + String.valueOf(this.getSupportedAuthentication()) + ", parameters=" + String.valueOf(this.getParameters()) + ", models=" + String.valueOf(this.getModels()) + ")";
    }

    public static class AuthenticationMethod {
        private boolean enabled;
        private List<Token> tokens;

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<Token> getTokens() {
            return this.tokens;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setTokens(List<Token> tokens) {
            this.tokens = tokens;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthenticationMethod)) {
                return false;
            }
            AuthenticationMethod other = (AuthenticationMethod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            List<Token> this$tokens = this.getTokens();
            List<Token> other$tokens = other.getTokens();
            return !(this$tokens == null ? other$tokens != null : !((Object)this$tokens).equals(other$tokens));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthenticationMethod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            List<Token> $tokens = this.getTokens();
            result = result * 59 + ($tokens == null ? 43 : ((Object)$tokens).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingProvider.AuthenticationMethod(enabled=" + this.isEnabled() + ", tokens=" + String.valueOf(this.getTokens()) + ")";
        }
    }

    public static class Validation {
        private List<Integer> numericRange;

        public List<Integer> getNumericRange() {
            return this.numericRange;
        }

        public void setNumericRange(List<Integer> numericRange) {
            this.numericRange = numericRange;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Validation)) {
                return false;
            }
            Validation other = (Validation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$numericRange = this.getNumericRange();
            List<Integer> other$numericRange = other.getNumericRange();
            return !(this$numericRange == null ? other$numericRange != null : !((Object)this$numericRange).equals(other$numericRange));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Validation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $numericRange = this.getNumericRange();
            result = result * 59 + ($numericRange == null ? 43 : ((Object)$numericRange).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingProvider.Validation(numericRange=" + String.valueOf(this.getNumericRange()) + ")";
        }
    }

    public static class Parameter {
        private String name;
        private String type;
        private boolean required;
        private String defaultValue;
        private Validation validation;
        private String help;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Validation getValidation() {
            return this.validation;
        }

        public String getHelp() {
            return this.help;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setValidation(Validation validation) {
            this.validation = validation;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Validation this$validation = this.getValidation();
            Validation other$validation = other.getValidation();
            if (this$validation == null ? other$validation != null : !((Object)this$validation).equals(other$validation)) {
                return false;
            }
            String this$help = this.getHelp();
            String other$help = other.getHelp();
            return !(this$help == null ? other$help != null : !this$help.equals(other$help));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Validation $validation = this.getValidation();
            result = result * 59 + ($validation == null ? 43 : ((Object)$validation).hashCode());
            String $help = this.getHelp();
            result = result * 59 + ($help == null ? 43 : $help.hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingProvider.Parameter(name=" + this.getName() + ", type=" + this.getType() + ", required=" + this.isRequired() + ", defaultValue=" + this.getDefaultValue() + ", validation=" + String.valueOf(this.getValidation()) + ", help=" + this.getHelp() + ")";
        }
    }

    public static class Token {
        private String forwarded;
        private String accepted;

        public String getForwarded() {
            return this.forwarded;
        }

        public String getAccepted() {
            return this.accepted;
        }

        public void setForwarded(String forwarded) {
            this.forwarded = forwarded;
        }

        public void setAccepted(String accepted) {
            this.accepted = accepted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$forwarded = this.getForwarded();
            String other$forwarded = other.getForwarded();
            if (this$forwarded == null ? other$forwarded != null : !this$forwarded.equals(other$forwarded)) {
                return false;
            }
            String this$accepted = this.getAccepted();
            String other$accepted = other.getAccepted();
            return !(this$accepted == null ? other$accepted != null : !this$accepted.equals(other$accepted));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Token;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $forwarded = this.getForwarded();
            result = result * 59 + ($forwarded == null ? 43 : $forwarded.hashCode());
            String $accepted = this.getAccepted();
            result = result * 59 + ($accepted == null ? 43 : $accepted.hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingProvider.Token(forwarded=" + this.getForwarded() + ", accepted=" + this.getAccepted() + ")";
        }
    }

    public static class Model {
        private String name;
        private Integer vectorDimension;
        private List<Parameter> parameters;

        public String getName() {
            return this.name;
        }

        public Integer getVectorDimension() {
            return this.vectorDimension;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVectorDimension(Integer vectorDimension) {
            this.vectorDimension = vectorDimension;
        }

        public void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Model)) {
                return false;
            }
            Model other = (Model)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$vectorDimension = this.getVectorDimension();
            Integer other$vectorDimension = other.getVectorDimension();
            if (this$vectorDimension == null ? other$vectorDimension != null : !((Object)this$vectorDimension).equals(other$vectorDimension)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Parameter> this$parameters = this.getParameters();
            List<Parameter> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Model;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $vectorDimension = this.getVectorDimension();
            result = result * 59 + ($vectorDimension == null ? 43 : ((Object)$vectorDimension).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Parameter> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "EmbeddingProvider.Model(name=" + this.getName() + ", vectorDimension=" + this.getVectorDimension() + ", parameters=" + String.valueOf(this.getParameters()) + ")";
        }
    }
}

