/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.FilterBuilder;
import com.datastax.astra.client.model.FilterOperator;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.JsonUtils;
import java.util.Map;
import lombok.NonNull;

public class Filter
extends Document {
    public Filter() {
    }

    public Filter(@NonNull String fieldName, @NonNull FilterOperator cond, @NonNull Object value) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (cond == null) {
            throw new NullPointerException("cond is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.documentMap.put(fieldName, Map.of(cond.getOperator(), value));
    }

    public FilterBuilder where(String fieldName) {
        Assert.hasLength(fieldName, "fieldName");
        return new FilterBuilder(this, fieldName);
    }

    public Filter where(String fieldName, FilterOperator cond, Object value) {
        this.documentMap.put(fieldName, Map.of(cond.getOperator(), value));
        return this;
    }

    public static Filter findById(String id) {
        return new Filter().where("_id").isEqualsTo(id);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String toJson() {
        return JsonUtils.marshall(this);
    }
}

