/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.FilterOperator;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class Filters {
    private Filters() {
    }

    public static Filter eq(Object value) {
        return Filters.eq("_id", value);
    }

    public static Filter eq(String fieldName, Object value) {
        return new Filter().where(fieldName).isEqualsTo(value);
    }

    public static Filter ne(String fieldName, Object value) {
        return new Filter().where(fieldName).isNotEqualsTo(value);
    }

    public static Filter gt(String fieldName, Number value) {
        return new Filter().where(fieldName).isGreaterThan(value);
    }

    public static Filter gt(String fieldName, Instant value) {
        return new Filter().where(fieldName).isGreaterThan(value);
    }

    public static Filter gt(String fieldName, Date value) {
        return new Filter().where(fieldName).isGreaterThan(value);
    }

    public static Filter gt(String fieldName, Calendar value) {
        return new Filter().where(fieldName).isGreaterThan(value);
    }

    public static Filter gte(String fieldName, Number value) {
        return new Filter().where(fieldName).isGreaterOrEqualsThan(value);
    }

    public static Filter gte(String fieldName, Instant value) {
        return new Filter().where(fieldName).isGreaterOrEqualsThan(value);
    }

    public static Filter gte(String fieldName, Calendar value) {
        return new Filter().where(fieldName).isGreaterOrEqualsThan(value);
    }

    public static Filter gte(String fieldName, Date value) {
        return new Filter().where(fieldName).isGreaterOrEqualsThan(value);
    }

    public static Filter lt(String fieldName, Number value) {
        return new Filter().where(fieldName).isLessThan(value);
    }

    public static Filter lt(String fieldName, Date value) {
        return new Filter().where(fieldName).isLessThan(value);
    }

    public static Filter lt(String fieldName, Instant value) {
        return new Filter().where(fieldName).isLessThan(value);
    }

    public static Filter lt(String fieldName, Calendar value) {
        return new Filter().where(fieldName).isLessThan(value);
    }

    public static Filter lte(String fieldName, Number value) {
        return new Filter().where(fieldName, FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public static Filter lte(String fieldName, Instant value) {
        return new Filter().where(fieldName, FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public static Filter lte(String fieldName, Date value) {
        return new Filter().where(fieldName, FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public static Filter lte(String fieldName, Calendar value) {
        return new Filter().where(fieldName, FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public static Filter hasSize(String fieldName, int size) {
        return new Filter().where(fieldName).hasSize(size);
    }

    public static Filter exists(String fieldName) {
        return new Filter().where(fieldName).exists();
    }

    public static Filter all(String fieldName, Object ... values) {
        return new Filter().where(fieldName).isAnArrayExactlyEqualsTo(values);
    }

    @SafeVarargs
    public static <V> Filter in(String fieldName, V ... values) {
        return new Filter().where(fieldName).isInArray(values);
    }

    @SafeVarargs
    public static <V> Filter nin(String fieldName, V ... values) {
        return new Filter().where(fieldName).isNotInArray(values);
    }

    public static Filter and(Filter ... filters) {
        return Filters.and(Arrays.asList(filters));
    }

    public static Filter and(Iterable<Filter> filters) {
        Filter andFilter = new Filter();
        andFilter.documentMap.put("$and", filters);
        return andFilter;
    }

    public static Filter or(Iterable<Filter> filters) {
        Filter andFilter = new Filter();
        andFilter.documentMap.put("$or", filters);
        return andFilter;
    }

    public static Filter or(Filter ... filters) {
        return Filters.or(Arrays.asList(filters));
    }

    public static Filter not(Filter filter) {
        Filter andFilter = new Filter();
        andFilter.documentMap.put("$not", filter);
        return andFilter;
    }
}

