/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.Collection;
import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.FindIterator;
import com.datastax.astra.client.model.FindOptions;
import com.datastax.astra.client.model.PageableIterable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindIterable<T>
extends PageableIterable<T>
implements Iterable<T> {
    private static final Logger log = LoggerFactory.getLogger(FindIterable.class);
    protected FindIterator<T> currentPageIterator;

    public FindIterable(Collection<T> collection, Filter filter, FindOptions options) {
        this.collection = collection;
        this.filter = filter;
        this.options = options;
    }

    @Override
    @NonNull
    public FindIterator<T> iterator() {
        if (this.currentPageIterator == null) {
            this.active = this.fetchNextPage();
            this.currentPageIterator = new FindIterator(this);
        }
        return this.currentPageIterator;
    }

    public List<T> all() {
        if (this.exhausted) {
            throw new IllegalStateException("Iterable is already exhausted.");
        }
        if (this.active) {
            throw new IllegalStateException("Iterable has already been started");
        }
        ArrayList results = new ArrayList();
        for (Object t : this) {
            results.add(t);
        }
        return results;
    }

    public FindIterator<T> getCurrentPageIterator() {
        return this.currentPageIterator;
    }
}

