/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.PageableIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FindIterator<T>
implements Iterator<T> {
    private final PageableIterable<T> parentIterable;
    private int availableWithoutFetch;
    private Iterator<T> resultsIterator;

    public FindIterator(PageableIterable<T> findIterable) {
        this.parentIterable = findIterable;
        this.availableWithoutFetch = findIterable.getCurrentPage().getResults().size();
        this.resultsIterator = findIterable.getCurrentPage().getResults().iterator();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        boolean bl = hasNext = this.resultsIterator.hasNext() || this.parentIterable.getCurrentPage().getPageState().isPresent();
        if (!hasNext) {
            this.parentIterable.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        if (this.resultsIterator.hasNext()) {
            --this.availableWithoutFetch;
            this.parentIterable.active = true;
            this.parentIterable.getTotalItemProcessed().incrementAndGet();
            return this.resultsIterator.next();
        }
        if (this.parentIterable.getCurrentPage().getPageState().isPresent()) {
            this.parentIterable.fetchNextPage();
            this.availableWithoutFetch = this.parentIterable.getCurrentPage().getResults().size();
            this.resultsIterator = this.parentIterable.getCurrentPage().getResults().iterator();
            return this.next();
        }
        this.parentIterable.active = false;
        this.parentIterable.exhausted = true;
        throw new NoSuchElementException("Current page is exhausted and no new page available");
    }

    public int available() {
        return this.availableWithoutFetch;
    }

    public PageableIterable<T> getParentIterable() {
        return this.parentIterable;
    }

    public int getAvailableWithoutFetch() {
        return this.availableWithoutFetch;
    }

    public Iterator<T> getResultsIterator() {
        return this.resultsIterator;
    }
}

