/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Projection;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.Sorts;
import com.datastax.astra.internal.utils.OptionsUtils;
import java.util.Map;

public class FindOneAndDeleteOptions
extends CommandOptions<FindOneAndDeleteOptions> {
    private Document sort;
    private Map<String, Object> projection;

    public FindOneAndDeleteOptions sort(Sort ... sort) {
        return this.sort(OptionsUtils.sort(sort));
    }

    public FindOneAndDeleteOptions sort(Map<String, Object> rawSort) {
        Document doc = new Document();
        doc.putAll((Map<? extends String, ?>)rawSort);
        return this.sort(doc);
    }

    public FindOneAndDeleteOptions sort(Document sorClause) {
        this.setSort(sorClause);
        return this;
    }

    public FindOneAndDeleteOptions sort(String vectorize, Sort ... sorts) {
        Document doc = Sorts.vectorize(vectorize);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneAndDeleteOptions sort(float[] vector, Sort ... sorts) {
        Document doc = Sorts.vector(vector);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneAndDeleteOptions projection(Projection ... projection) {
        this.setProjection(OptionsUtils.projection(projection));
        return this;
    }

    public Document getSort() {
        return this.sort;
    }

    public Map<String, Object> getProjection() {
        return this.projection;
    }

    public void setSort(Document sort) {
        this.sort = sort;
    }

    public void setProjection(Map<String, Object> projection) {
        this.projection = projection;
    }
}

