/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Projection;
import com.datastax.astra.client.model.ReturnDocument;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.Sorts;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.OptionsUtils;
import java.util.Map;

public class FindOneAndUpdateOptions
extends CommandOptions<FindOneAndUpdateOptions> {
    private Document sort;
    private Map<String, Object> projection;
    private Boolean upsert;
    private String returnDocument;

    public FindOneAndUpdateOptions sort(Sort ... sort) {
        return this.sort(OptionsUtils.sort(sort));
    }

    public FindOneAndUpdateOptions sort(Map<String, Object> rawSort) {
        Document doc = new Document();
        doc.putAll((Map<? extends String, ?>)rawSort);
        return this.sort(doc);
    }

    public FindOneAndUpdateOptions sort(Document sorClause) {
        this.setSort(sorClause);
        return this;
    }

    public FindOneAndUpdateOptions sort(String vectorize, Sort ... sorts) {
        Document doc = Sorts.vectorize(vectorize);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneAndUpdateOptions sort(float[] vector, Sort ... sorts) {
        Document doc = Sorts.vector(vector);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneAndUpdateOptions projection(Projection ... projection) {
        this.setProjection(OptionsUtils.projection(projection));
        return this;
    }

    public FindOneAndUpdateOptions returnDocumentAfter() {
        this.returnDocument = ReturnDocument.AFTER.getKey();
        return this;
    }

    public FindOneAndUpdateOptions returnDocumentBefore() {
        this.returnDocument = ReturnDocument.BEFORE.getKey();
        return this;
    }

    public FindOneAndUpdateOptions upsert(Boolean upsert) {
        Assert.notNull(upsert, "upsert");
        this.upsert = upsert;
        return this;
    }

    public Document getSort() {
        return this.sort;
    }

    public Map<String, Object> getProjection() {
        return this.projection;
    }

    public Boolean getUpsert() {
        return this.upsert;
    }

    public String getReturnDocument() {
        return this.returnDocument;
    }

    public void setSort(Document sort) {
        this.sort = sort;
    }

    public void setProjection(Map<String, Object> projection) {
        this.projection = projection;
    }

    public void setUpsert(Boolean upsert) {
        this.upsert = upsert;
    }

    public void setReturnDocument(String returnDocument) {
        this.returnDocument = returnDocument;
    }

    @Deprecated
    public static class Builder {
        private Builder() {
        }

        public static FindOneAndUpdateOptions sort(Sort ... sort) {
            return new FindOneAndUpdateOptions().sort(sort);
        }

        public static FindOneAndUpdateOptions projection(Projection ... projection) {
            return new FindOneAndUpdateOptions().projection(projection);
        }

        public static FindOneAndUpdateOptions returnDocumentAfter() {
            return new FindOneAndUpdateOptions().returnDocumentAfter();
        }

        public static FindOneAndUpdateOptions returnDocumentBefore() {
            return new FindOneAndUpdateOptions().returnDocumentBefore();
        }

        public static FindOneAndUpdateOptions upsert(Boolean upsert) {
            return new FindOneAndUpdateOptions().upsert(upsert);
        }

        public static FindOneAndUpdateOptions sort(String vectorize, Sort ... sorts) {
            return new FindOneAndUpdateOptions().sort(vectorize, sorts);
        }

        public static FindOneAndUpdateOptions sort(float[] vector, Sort ... sorts) {
            return new FindOneAndUpdateOptions().sort(vector, sorts);
        }
    }
}

