/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Projection;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.Sorts;
import com.datastax.astra.internal.utils.OptionsUtils;
import java.util.Map;

public class FindOneOptions
extends CommandOptions<FindOneOptions> {
    private Document sort;
    private Map<String, Object> projection;
    private Boolean includeSimilarity;
    private Boolean includeSortVector;

    public FindOneOptions sort(Sort ... sort) {
        return this.sort(OptionsUtils.sort(sort));
    }

    public FindOneOptions sort(Map<String, Object> rawSort) {
        Document doc = new Document();
        doc.putAll((Map<? extends String, ?>)rawSort);
        return this.sort(doc);
    }

    public FindOneOptions sort(Document sorClause) {
        this.setSort(sorClause);
        return this;
    }

    public FindOneOptions sort(String vectorize, Sort ... sorts) {
        Document doc = Sorts.vectorize(vectorize);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneOptions sort(float[] vector, Sort ... sorts) {
        Document doc = Sorts.vector(vector);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOneOptions projection(Projection ... projection) {
        this.setProjection(OptionsUtils.projection(projection));
        return this;
    }

    public FindOneOptions includeSimilarity() {
        this.includeSimilarity = true;
        return this;
    }

    public FindOneOptions includeSortVector() {
        this.includeSortVector = true;
        return this;
    }

    public Document getSort() {
        return this.sort;
    }

    public Map<String, Object> getProjection() {
        return this.projection;
    }

    public Boolean getIncludeSimilarity() {
        return this.includeSimilarity;
    }

    public Boolean getIncludeSortVector() {
        return this.includeSortVector;
    }

    public void setSort(Document sort) {
        this.sort = sort;
    }

    public void setProjection(Map<String, Object> projection) {
        this.projection = projection;
    }

    public void setIncludeSimilarity(Boolean includeSimilarity) {
        this.includeSimilarity = includeSimilarity;
    }

    public void setIncludeSortVector(Boolean includeSortVector) {
        this.includeSortVector = includeSortVector;
    }
}

