/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.FindOneOptions;
import com.datastax.astra.client.model.Projection;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.Sorts;
import com.datastax.astra.internal.utils.OptionsUtils;
import java.util.Map;

public class FindOptions
extends CommandOptions<FindOneOptions> {
    private Document sort;
    private Map<String, Object> projection;
    private Integer skip;
    private Integer limit;
    private Boolean includeSimilarity;
    private Boolean includeSortVector;
    private String pageState;

    public FindOptions sort(Sort ... sort) {
        return this.sort(OptionsUtils.sort(sort));
    }

    public FindOptions sort(Map<String, Object> rawSort) {
        Document doc = new Document();
        doc.putAll((Map<? extends String, ?>)rawSort);
        return this.sort(doc);
    }

    public FindOptions sort(Document sorClause) {
        this.setSort(sorClause);
        return this;
    }

    public FindOptions sort(String vectorize, Sort ... sorts) {
        Document doc = Sorts.vectorize(vectorize);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOptions sort(float[] vector, Sort ... sorts) {
        Document doc = Sorts.vector(vector);
        if (sorts != null) {
            doc.putAll(OptionsUtils.sort(sorts));
        }
        return this.sort(doc);
    }

    public FindOptions projection(Projection ... projection) {
        this.setProjection(OptionsUtils.projection(projection));
        return this;
    }

    public FindOptions includeSimilarity() {
        this.includeSimilarity = true;
        return this;
    }

    public FindOptions includeSortVector() {
        this.includeSortVector = true;
        return this;
    }

    public FindOptions pageState(String pageState) {
        this.pageState = pageState;
        return this;
    }

    public FindOptions skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must be positive");
        }
        this.skip = skip;
        return this;
    }

    public FindOptions limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        this.limit = limit;
        return this;
    }

    public Document getSort() {
        return this.sort;
    }

    public Map<String, Object> getProjection() {
        return this.projection;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIncludeSimilarity() {
        return this.includeSimilarity;
    }

    public Boolean getIncludeSortVector() {
        return this.includeSortVector;
    }

    public String getPageState() {
        return this.pageState;
    }

    public void setSort(Document sort) {
        this.sort = sort;
    }

    public void setProjection(Map<String, Object> projection) {
        this.projection = projection;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setIncludeSimilarity(Boolean includeSimilarity) {
        this.includeSimilarity = includeSimilarity;
    }

    public void setIncludeSortVector(Boolean includeSortVector) {
        this.includeSortVector = includeSortVector;
    }

    public void setPageState(String pageState) {
        this.pageState = pageState;
    }
}

