/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.NamespaceInformation;
import java.util.HashMap;
import java.util.Map;

public class NamespaceOptions {
    private final Map<String, Object> replication = new HashMap<String, Object>();

    private NamespaceOptions() {
    }

    public static NamespaceOptions simpleStrategy(int replicationFactor) {
        NamespaceOptions options = new NamespaceOptions();
        options.replication.put("class", NamespaceInformation.ReplicationStrategy.SIMPLE_STRATEGY.getValue());
        options.replication.put("replication_factor", replicationFactor);
        return options;
    }

    public static NamespaceOptions networkTopologyStrategy(Map<String, Integer> datacenters) {
        NamespaceOptions options = new NamespaceOptions();
        options.replication.put("class", NamespaceInformation.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY.getValue());
        options.replication.putAll(datacenters);
        return options;
    }

    public Map<String, Object> getReplication() {
        return this.replication;
    }
}

