/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import java.util.List;
import java.util.Optional;

public class Page<R> {
    private final String pageState;
    protected float[] sortVector;
    private final List<R> results;

    public Page(String pageState, List<R> results, float[] sortVector) {
        this.pageState = pageState;
        this.results = results;
        this.sortVector = sortVector;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public Optional<R> findFirst() {
        if (!this.isEmpty()) {
            return Optional.ofNullable(this.results.get(0));
        }
        return Optional.empty();
    }

    public R one() {
        if (this.getResults() == null || this.getResults().size() != 1) {
            throw new IllegalStateException("Current page does not contain a single record");
        }
        return this.getResults().get(0);
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }

    public Optional<float[]> getSortVector() {
        return Optional.ofNullable(this.sortVector);
    }

    public List<R> getResults() {
        return this.results;
    }
}

