/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.Collection;
import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.FindOptions;
import com.datastax.astra.client.model.Page;
import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class PageableIterable<T>
implements Closeable {
    protected Collection<T> collection;
    protected final AtomicInteger totalItemProcessed = new AtomicInteger(0);
    protected boolean active = false;
    protected boolean exhausted = false;
    protected Page<T> currentPage;
    protected int currentPageAvailable;
    protected Filter filter;
    protected FindOptions options;

    protected PageableIterable() {
    }

    public boolean fetchNextPage() {
        if (this.currentPage == null || this.currentPage.getPageState().isPresent()) {
            if (this.currentPage != null && this.currentPage.getPageState().isPresent()) {
                this.options.setPageState(this.currentPage.getPageState().get());
            }
            this.currentPage = this.collection.findPage(this.filter, this.options);
        }
        return false;
    }

    public Optional<float[]> getSortVector() {
        if (this.currentPage == null) {
            throw new IllegalStateException("The iterator is not active and the 'sortVector' cannot be retrieved, please use 'next()' first.");
        }
        return this.currentPage.getSortVector();
    }

    @Override
    public void close() {
        this.active = false;
        this.exhausted = true;
    }

    public Collection<T> getCollection() {
        return this.collection;
    }

    public AtomicInteger getTotalItemProcessed() {
        return this.totalItemProcessed;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public Page<T> getCurrentPage() {
        return this.currentPage;
    }

    public int getCurrentPageAvailable() {
        return this.currentPageAvailable;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public FindOptions getOptions() {
        return this.options;
    }
}

