/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.Document;
import com.datastax.astra.internal.utils.JsonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Update
extends Document {
    public Update() {
    }

    public Update(String json) {
        this.documentMap.putAll(JsonUtils.unMarshallBean(json, Map.class));
    }

    public Update(Map<String, Object> obj) {
        this.documentMap.putAll(obj);
    }

    public static Update create() {
        return new Update();
    }

    public Update inc(String key, Double offset) {
        return this.update("$inc", key, offset);
    }

    public Update unset(String fieldName) {
        return this.update("$unset", fieldName, "");
    }

    public Update set(String key, Object value) {
        return this.update("$set", key, value);
    }

    public Update set(Document fields) {
        if (fields != null) {
            fields.forEach(this::set);
        }
        return this;
    }

    public Update min(String key, Object value) {
        return this.update("$min", key, value);
    }

    public Update push(String key, Object value) {
        return this.update("$push", key, value);
    }

    public Update pop(String key, Object value) {
        return this.update("$pop", key, value);
    }

    public Update pushEach(String key, List<Object> values, Integer position) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("$each", values);
        if (null != position) {
            value.put("$position", position);
        }
        return this.update("$push", key, value);
    }

    public Update addToSet(String key, Object value) {
        return this.update("$addToSet", key, value);
    }

    public Update rename(String key, Object value) {
        return this.update("$rename", key, value);
    }

    public Update updateCurrentDate(String ... fields) {
        Arrays.stream(fields).forEach((? super T key) -> this.update("$currentDate", (String)key, true));
        return this;
    }

    public Update updateMul(Map<String, Double> fields) {
        fields.forEach((key, value) -> this.update("$mul", (String)key, value));
        return this;
    }

    public Update updateSetOnInsert(Map<String, Double> fields) {
        fields.forEach((key, value) -> this.update("$setOnInsert", (String)key, value));
        return this;
    }

    private Update update(String operation, String key, Object value) {
        this.documentMap.computeIfAbsent(operation, k -> new LinkedHashMap());
        ((Map)this.documentMap.get(operation)).put(key, value);
        return this;
    }
}

