/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client.model;

import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.Sorts;
import com.datastax.astra.internal.utils.OptionsUtils;

public class UpdateOneOptions
extends CommandOptions<UpdateOneOptions> {
    private Boolean upsert;
    private Document sort;

    public UpdateOneOptions upsert(Boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public UpdateOneOptions sort(Sort ... sort) {
        this.setSort(OptionsUtils.sort(sort));
        return this;
    }

    public UpdateOneOptions vectorize(String vectorize, Sort ... sorts) {
        this.setSort(Sorts.vectorize(vectorize));
        if (sorts != null) {
            this.getSort().putAll(OptionsUtils.sort(sorts));
        }
        return this;
    }

    public UpdateOneOptions vector(float[] vector, Sort ... sorts) {
        this.setSort(Sorts.vector(vector));
        if (sorts != null) {
            this.getSort().putAll(OptionsUtils.sort(sorts));
        }
        return this;
    }

    public Boolean getUpsert() {
        return this.upsert;
    }

    public Document getSort() {
        return this.sort;
    }

    public void setUpsert(Boolean upsert) {
        this.upsert = upsert;
    }

    public void setSort(Document sort) {
        this.sort = sort;
    }

    @Deprecated
    public static class Builder {
        private Builder() {
        }

        public static UpdateOneOptions upsert(boolean upsert) {
            return new UpdateOneOptions().upsert(upsert);
        }

        public static UpdateOneOptions sort(Sort ... sort) {
            return new UpdateOneOptions().sort(sort);
        }

        public static UpdateOneOptions vectorize(String vectorize, Sort ... sort) {
            return new UpdateOneOptions().vectorize(vectorize, sort);
        }

        public static UpdateOneOptions vector(float[] vector, Sort ... sort) {
            return new UpdateOneOptions().vector(vector, sort);
        }
    }
}

