/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.api;

import com.datastax.astra.client.model.Document;
import com.datastax.astra.internal.api.ApiData;
import com.datastax.astra.internal.api.ApiError;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.JsonUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;

public class ApiResponse
implements Serializable {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Document status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private transient List<ApiError> errors;
    private transient ApiData data;

    public Stream<String> getStatusKeyAsStringStream(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Assert.isTrue(this.status.containsKey(key), "Key not found in status map");
        return ((ArrayList)this.status.get(key)).stream();
    }

    public <T> List<T> getStatusKeyAsList(@NonNull String key, Class<T> targetClass) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Assert.isTrue(this.status.containsKey(key), "Key not found in status map");
        return (List)JsonUtils.getDataApiObjectMapper().convertValue(this.status.get(key), (JavaType)JsonUtils.getDataApiObjectMapper().getTypeFactory().constructCollectionType(List.class, targetClass));
    }

    public <T> Map<String, T> getStatusKeyAsMap(@NonNull String key, Class<T> targetClass) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Assert.isTrue(this.status.containsKey(key), "Key not found in status map");
        return (Map)JsonUtils.getDataApiObjectMapper().convertValue(this.status.get(key), (JavaType)JsonUtils.getDataApiObjectMapper().getTypeFactory().constructMapType(Map.class, String.class, targetClass));
    }

    public Document getStatus() {
        return this.status;
    }

    public List<ApiError> getErrors() {
        return this.errors;
    }

    public ApiData getData() {
        return this.data;
    }

    public void setStatus(Document status) {
        this.status = status;
    }

    public void setErrors(List<ApiError> errors) {
        this.errors = errors;
    }

    public void setData(ApiData data) {
        this.data = data;
    }
}

