/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.api;

import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import java.util.UUID;

public class AstraApiEndpoint {
    AstraEnvironment env;
    UUID databaseId;
    String databaseRegion;

    public AstraApiEndpoint() {
    }

    public static AstraApiEndpoint parse(String endpointUrl) {
        String tmpUrl;
        Assert.notNull((Object)endpointUrl, (String)"endpoint");
        AstraApiEndpoint endpoint = new AstraApiEndpoint();
        if (endpointUrl.contains(AstraEnvironment.PROD.getAppsSuffix())) {
            endpoint.env = AstraEnvironment.PROD;
            tmpUrl = endpointUrl.replaceAll(AstraEnvironment.PROD.getAppsSuffix(), "");
        } else if (endpointUrl.contains(AstraEnvironment.TEST.getAppsSuffix())) {
            endpoint.env = AstraEnvironment.TEST;
            tmpUrl = endpointUrl.replaceAll(AstraEnvironment.TEST.getAppsSuffix(), "");
        } else if (endpointUrl.contains(AstraEnvironment.DEV.getAppsSuffix())) {
            endpoint.env = AstraEnvironment.DEV;
            tmpUrl = endpointUrl.replaceAll(AstraEnvironment.DEV.getAppsSuffix(), "");
        } else {
            throw new IllegalArgumentException("Unable to detect environment from endpoint");
        }
        tmpUrl = tmpUrl.replace("https://", "");
        endpoint.databaseId = UUID.fromString(tmpUrl.substring(0, 36));
        endpoint.databaseRegion = tmpUrl.substring(37);
        return endpoint;
    }

    public AstraApiEndpoint(UUID databaseId, String databaseRegion, AstraEnvironment env) {
        this.databaseId = databaseId;
        this.databaseRegion = databaseRegion;
        this.env = env;
    }

    public String getApiEndPoint() {
        return ApiLocator.getApiJsonEndpoint((AstraEnvironment)this.env, (String)this.databaseId.toString(), (String)this.databaseRegion);
    }

    public String getOriginalEndPoint() {
        return this.getApiEndPoint().replace("/api/json", "");
    }

    public AstraEnvironment getEnv() {
        return this.env;
    }

    public UUID getDatabaseId() {
        return this.databaseId;
    }

    public String getDatabaseRegion() {
        return this.databaseRegion;
    }

    public void setEnv(AstraEnvironment env) {
        this.env = env;
    }

    public void setDatabaseId(UUID databaseId) {
        this.databaseId = databaseId;
    }

    public void setDatabaseRegion(String databaseRegion) {
        this.databaseRegion = databaseRegion;
    }
}

