/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.auth;

import com.datastax.astra.internal.api.ApiResponseHttp;
import com.datastax.astra.internal.auth.TokenProvider;
import com.datastax.astra.internal.http.RetryHttpClient;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.JsonUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;

@Deprecated(since="Data API 1.0.6", forRemoval=true)
public class TokenProviderStargate
implements TokenProvider {
    public static final RetryHttpClient HTTP_CLIENT = new RetryHttpClient();
    public static final String DEFAULT_USERNAME = "cassandra";
    public static final String DEFAULT_CREDENTIALS = "cassandra";
    public static final String DEFAULT_AUTH_URL = "http://localhost:8081";
    public static final Duration DEFAULT_TIMEOUT_TOKEN;
    private static final Duration tokenTtl;
    private final String username;
    private final String password;
    private long tokenCreationTime = 0L;
    private String token;
    private final String authenticationUrl;

    public TokenProviderStargate() {
        this("cassandra", "cassandra", DEFAULT_AUTH_URL);
    }

    public TokenProviderStargate(String username, String password, String url) {
        Assert.hasLength(username, "username");
        Assert.hasLength(password, "password");
        Assert.hasLength(url, "Url list");
        this.username = username;
        this.password = password;
        this.authenticationUrl = url;
    }

    @Override
    public String getToken() {
        if (System.currentTimeMillis() - this.tokenCreationTime > 1000L * tokenTtl.getSeconds()) {
            this.token = this.renewToken();
            this.tokenCreationTime = System.currentTimeMillis();
        }
        return this.token;
    }

    private String renewToken() {
        String body = JsonUtils.marshall(Map.of("username", this.username, "password", this.password));
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(this.authenticationUrl + "/v1/auth")).method("POST", HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").header("User-Agent", "data-api-client-java").header("X-Cassandra-Request-Id", UUID.randomUUID().toString()).header("X-Requested-With", "data-api-client-java").build();
            ApiResponseHttp response = HTTP_CLIENT.parseHttpResponse((HttpResponse)HTTP_CLIENT.executeHttpRequest(request).getResult());
            if (response != null && (201 == response.getCode() || 200 == response.getCode())) {
                return (String)JsonUtils.unMarshallBean(response.getBody(), Map.class).get("authToken");
            }
            String errorMessage = response != null ? response.getBody() : "no response";
            throw new IllegalStateException("Cannot generate authentication token " + errorMessage);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Authentication URL was invalid " + this.authenticationUrl, e);
        }
    }

    static {
        tokenTtl = DEFAULT_TIMEOUT_TOKEN = Duration.ofMinutes(30L);
    }
}

