/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.auth;

import com.datastax.astra.internal.auth.TokenProvider;
import com.datastax.astra.internal.http.RetryHttpClient;
import com.datastax.astra.internal.utils.Assert;
import java.util.Base64;

public class UsernamePasswordTokenProvider
implements TokenProvider {
    public static final RetryHttpClient HTTP_CLIENT = new RetryHttpClient();
    public static final String DEFAULT_USERNAME = "cassandra";
    public static final String DEFAULT_CREDENTIALS = "cassandra";
    private final String token;

    public UsernamePasswordTokenProvider() {
        this("cassandra", "cassandra");
    }

    public UsernamePasswordTokenProvider(String username, String password) {
        Assert.hasLength(username, "username");
        Assert.hasLength(password, "password");
        Base64.Encoder encoder = Base64.getEncoder();
        this.token = "Cassandra:" + Base64.getEncoder().encodeToString(username.getBytes()) + ":" + Base64.getEncoder().encodeToString(password.getBytes());
    }

    @Override
    public String getToken() {
        return this.token;
    }
}

