/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.command;

import com.datastax.astra.client.exception.DataApiResponseException;
import com.datastax.astra.client.model.Command;
import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.CommandRunner;
import com.datastax.astra.internal.api.ApiResponse;
import com.datastax.astra.internal.api.ApiResponseHttp;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.command.ExecutionInfos;
import com.datastax.astra.internal.http.RetryHttpClient;
import com.datastax.astra.internal.utils.CompletableFutures;
import com.datastax.astra.internal.utils.JsonUtils;
import com.evanlennick.retry4j.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandRunner
implements CommandRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandRunner.class);
    protected RetryHttpClient httpClient;
    protected CommandOptions<?> commandOptions;

    protected AbstractCommandRunner() {
    }

    @Override
    public ApiResponse runCommand(Command command, CommandOptions<?> overridingOptions) {
        if (this.httpClient == null && (overridingOptions == null || overridingOptions.getHttpClientOptions().isEmpty())) {
            if (this.commandOptions.getHttpClientOptions().isEmpty()) {
                throw new IllegalStateException("HttpClientOptions is required in collection level options");
            }
            this.httpClient = new RetryHttpClient(this.commandOptions.getHttpClientOptions().get());
        }
        RetryHttpClient requestHttpClient = this.httpClient;
        if (overridingOptions != null && overridingOptions.getHttpClientOptions().isPresent()) {
            requestHttpClient = new RetryHttpClient(overridingOptions.getHttpClientOptions().get());
        }
        ArrayList<CommandObserver> observers = new ArrayList<CommandObserver>(this.commandOptions.getObservers().values());
        if (overridingOptions != null && overridingOptions.getObservers() != null) {
            for (Map.Entry<String, CommandObserver> observer : overridingOptions.getObservers().entrySet()) {
                if (this.commandOptions.getObservers().containsKey(observer.getKey())) continue;
                observers.add(observer.getValue());
            }
        }
        String token = this.commandOptions.getToken().get();
        if (overridingOptions != null && overridingOptions.getToken().isPresent()) {
            token = overridingOptions.getToken().get();
        }
        ExecutionInfos.DataApiExecutionInfoBuilder executionInfo = ExecutionInfos.builder().withCommand(command);
        try {
            String jsonCommand = JsonUtils.marshall(command);
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(new URI(this.getApiEndpoint())).header("Content-Type", "application/json").header("Accept", "application/json").header("User-Agent", requestHttpClient.getUserAgentHeader()).header("X-Requested-With", requestHttpClient.getUserAgentHeader()).header("X-Cassandra-Request-Id", UUID.randomUUID().toString()).header("X-Cassandra-Token", token).header("Authorization", "Bearer " + token).method("POST", HttpRequest.BodyPublishers.ofString(jsonCommand));
            builder.timeout(Duration.ofSeconds(requestHttpClient.getResponseTimeoutInSeconds()));
            this.commandOptions.getEmbeddingAPIKey().ifPresent(key -> builder.header("x-embedding-api-key", (String)key));
            if (overridingOptions != null) {
                overridingOptions.getEmbeddingAPIKey().ifPresent(key -> builder.header("x-embedding-api-key", (String)key));
            }
            HttpRequest request = builder.build();
            executionInfo.withRequestHeaders(request.headers().map());
            executionInfo.withRequestUrl(this.getApiEndpoint());
            Status<HttpResponse<String>> status = requestHttpClient.executeHttpRequest(request);
            ApiResponseHttp httpRes = requestHttpClient.parseHttpResponse((HttpResponse)status.getResult());
            executionInfo.withHttpResponse(httpRes);
            ApiResponse jsonRes = JsonUtils.unMarshallBean(httpRes.getBody(), ApiResponse.class);
            executionInfo.withApiResponse(jsonRes);
            if (jsonRes.getErrors() != null) {
                throw new DataApiResponseException(Collections.singletonList(executionInfo.build()));
            }
            ApiResponse apiResponse = jsonRes;
            return apiResponse;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL '" + this.getApiEndpoint() + "'", e);
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyASync(l -> l.onCommand(executionInfo.build()), observers));
        }
    }

    private void notifyASync(Consumer<CommandObserver> lambda, List<CommandObserver> observers) {
        if (observers != null) {
            CompletableFutures.allDone(observers.stream().map(l -> CompletableFuture.runAsync(() -> lambda.accept((CommandObserver)l))).collect(Collectors.toList()));
        }
    }

    @Override
    public <T> T runCommand(Command command, CommandOptions<?> options, Class<T> documentClass) {
        return this.mapAsDocument(this.runCommand(command, options), documentClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T mapAsDocument(ApiResponse api, Class<T> documentClass) {
        String payload;
        if (api.getData() != null) {
            if (api.getData().getDocument() != null) {
                payload = JsonUtils.marshall(api.getData().getDocument());
                return JsonUtils.unMarshallBean(payload, documentClass);
            } else {
                if (api.getData().getDocuments() == null) throw new IllegalStateException("Cannot marshall into '" + String.valueOf(documentClass) + "' no documents returned.");
                payload = JsonUtils.marshall(api.getData().getDocuments());
            }
            return JsonUtils.unMarshallBean(payload, documentClass);
        } else {
            payload = JsonUtils.marshall(api.getStatus());
        }
        return JsonUtils.unMarshallBean(payload, documentClass);
    }

    protected abstract String getApiEndpoint();

    public RetryHttpClient getHttpClient() {
        return this.httpClient;
    }

    public CommandOptions<?> getCommandOptions() {
        return this.commandOptions;
    }
}

