/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.command;

import com.datastax.astra.client.model.Command;
import com.datastax.astra.internal.api.ApiResponse;
import com.datastax.astra.internal.api.ApiResponseHttp;
import com.datastax.astra.internal.utils.Assert;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class ExecutionInfos
implements Serializable {
    private final Command command;
    private final Map<String, List<String>> requestHttpHeaders;
    private final String requestUrl;
    private final ApiResponse response;
    private final int responseHttpCode;
    private final Map<String, String> responseHttpHeaders;
    private final long executionTime;
    private final Instant executionDate;

    private ExecutionInfos(DataApiExecutionInfoBuilder builder) {
        this.command = builder.command;
        this.requestHttpHeaders = builder.requestHttpHeaders;
        this.response = builder.response;
        this.responseHttpHeaders = builder.responseHttpHeaders;
        this.responseHttpCode = builder.responseHttpCode;
        this.executionTime = builder.executionTime;
        this.executionDate = builder.executionDate;
        this.requestUrl = builder.requestUrl;
    }

    public static DataApiExecutionInfoBuilder builder() {
        return new DataApiExecutionInfoBuilder();
    }

    public Command getCommand() {
        return this.command;
    }

    public Map<String, List<String>> getRequestHttpHeaders() {
        return this.requestHttpHeaders;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public ApiResponse getResponse() {
        return this.response;
    }

    public int getResponseHttpCode() {
        return this.responseHttpCode;
    }

    public Map<String, String> getResponseHttpHeaders() {
        return this.responseHttpHeaders;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Instant getExecutionDate() {
        return this.executionDate;
    }

    public static class DataApiExecutionInfoBuilder {
        private Command command;
        private ApiResponse response;
        private long executionTime;
        private int responseHttpCode;
        private Map<String, List<String>> requestHttpHeaders;
        private Map<String, String> responseHttpHeaders;
        private final Instant executionDate = Instant.now();
        private String requestUrl;

        public DataApiExecutionInfoBuilder withCommand(Command command) {
            this.command = command;
            return this;
        }

        public DataApiExecutionInfoBuilder withRequestUrl(String url) {
            this.requestUrl = url;
            return this;
        }

        public DataApiExecutionInfoBuilder withRequestHeaders(Map<String, List<String>> headers) {
            this.requestHttpHeaders = headers;
            return this;
        }

        public void withApiResponse(ApiResponse response) {
            this.response = response;
        }

        public void withHttpResponse(ApiResponseHttp httpResponse) {
            Assert.notNull(httpResponse, "httpResponse");
            this.executionTime = System.currentTimeMillis() - 1000L * this.executionDate.getEpochSecond();
            this.responseHttpCode = httpResponse.getCode();
            this.responseHttpHeaders = httpResponse.getHeaders();
        }

        public ExecutionInfos build() {
            return new ExecutionInfos(this);
        }
    }
}

