/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.command;

import com.datastax.astra.internal.api.ApiData;
import com.datastax.astra.internal.api.ApiError;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.command.ExecutionInfos;
import com.datastax.astra.internal.utils.AnsiUtils;
import com.datastax.astra.internal.utils.JsonUtils;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingCommandObserver
implements CommandObserver {
    private final Logger logger;
    private final Level logLevel;

    public LoggingCommandObserver(Class<?> sourceClass) {
        this(Level.DEBUG, sourceClass);
    }

    public LoggingCommandObserver(Level logLevel, Class<?> sourceClass) {
        this.logLevel = logLevel;
        this.logger = LoggerFactory.getLogger(sourceClass);
    }

    @Override
    public void onCommand(ExecutionInfos executionInfo) {
        if (executionInfo != null) {
            List<ApiError> errors;
            String req = UUID.randomUUID().toString().substring(30);
            this.log("Command [" + AnsiUtils.cyan(executionInfo.getCommand().getName()) + "] with id [" + AnsiUtils.cyan(req) + "]", new Object[0]);
            this.log(AnsiUtils.magenta("[" + req + "][url]") + "=" + AnsiUtils.yellow("{}"), executionInfo.getRequestUrl());
            this.log(AnsiUtils.magenta("[" + req + "][request]") + "=" + AnsiUtils.yellow("{}"), JsonUtils.marshall(executionInfo.getCommand()));
            this.log(AnsiUtils.magenta("[" + req + "][response-code]") + "=" + AnsiUtils.yellow("{}"), executionInfo.getResponseHttpCode());
            this.log(AnsiUtils.magenta("[" + req + "][response-body]") + "=" + AnsiUtils.yellow("{}"), JsonUtils.marshall(executionInfo.getResponse()));
            this.log(AnsiUtils.magenta("[" + req + "][response-time]") + "=" + AnsiUtils.yellow("{}") + " millis.", executionInfo.getExecutionTime());
            ApiData data = executionInfo.getResponse().getData();
            if (data != null && data.getDocument() != null) {
                this.log(AnsiUtils.magenta("[" + req + "][apiData/document]") + "=" + AnsiUtils.yellow("1 document retrieved, id='{}'"), data.getDocument().getId(Object.class));
            }
            if (data != null && data.getDocuments() != null) {
                this.log(AnsiUtils.magenta("[" + req + "][apiData/documents]") + "=" + AnsiUtils.yellow("{} document(s)."), data.getDocuments().size());
            }
            if ((errors = executionInfo.getResponse().getErrors()) != null) {
                this.log(AnsiUtils.magenta("[" + req + "][errors]") + "=" + AnsiUtils.yellow("{}") + " errors detected.", errors.size());
                for (ApiError error : errors) {
                    this.log(AnsiUtils.magenta("[" + req + "][errors]") + "=" + AnsiUtils.yellow("{} [code={}]"), error.getErrorMessage(), error.getErrorCode());
                }
            }
        }
    }

    public void log(String message, Object ... params) {
        switch (this.logLevel) {
            case TRACE: {
                this.logger.trace(message, params);
                break;
            }
            case DEBUG: {
                this.logger.debug(message, params);
                break;
            }
            case INFO: {
                this.logger.info(message, params);
                break;
            }
            case WARN: {
                this.logger.warn(message, params);
                break;
            }
            case ERROR: {
                this.logger.error(message, params);
            }
        }
    }
}

