/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.http;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.exception.AuthenticationException;
import com.datastax.astra.client.exception.DataApiException;
import com.datastax.astra.client.model.HttpClientOptions;
import com.datastax.astra.internal.api.ApiResponseHttp;
import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpClient {
    private static final Logger log = LoggerFactory.getLogger(RetryHttpClient.class);
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_GRAPHQL = "application/graphql";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CASSANDRA = "X-Cassandra-Token";
    public static final String HEADER_REQUEST_ID = "X-Cassandra-Request-Id";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_REQUESTED_WITH = "X-Requested-With";
    public static final String HEADER_EMBEDDING_SERVICE_API_KEY = "x-embedding-api-key";
    public static final String REQUEST_WITH = "data-api-client-java";
    protected final HttpClient httpClient;
    protected final HttpClientOptions httpClientOptions;
    protected final RetryConfig retryConfig;
    public final Map<String, String> userAgents = new LinkedHashMap<String, String>();

    public RetryHttpClient() {
        this(DataAPIOptions.builder().build().getHttpClientOptions());
    }

    public RetryHttpClient(HttpClientOptions config) {
        this.httpClientOptions = config;
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        httpClientBuilder.version(config.getHttpVersion());
        httpClientBuilder.followRedirects(config.getHttpRedirect());
        httpClientBuilder.connectTimeout(Duration.ofSeconds(config.getConnectionRequestTimeoutInSeconds()));
        if (config.getProxy() != null) {
            httpClientBuilder.proxy(ProxySelector.of(new InetSocketAddress(config.getProxy().getHostname(), config.getProxy().getPort())));
        }
        this.httpClient = httpClientBuilder.build();
        this.retryConfig = new RetryConfigBuilder().retryOnAnyException().withDelayBetweenTries(Duration.ofMillis(config.getRetryDelay())).withMaxNumberOfTries(config.getRetryCount()).withExponentialBackoff().build();
        this.userAgents.put("astra-db-java", "astra-db-java");
        if (!this.userAgents.containsKey(config.getUserAgentCallerName())) {
            this.userAgents.put(config.getUserAgentCallerName(), config.getUserAgentCallerVersion());
        }
    }

    public String getUserAgentHeader() {
        if (this.userAgents.isEmpty()) {
            this.userAgents.put(REQUEST_WITH, RetryHttpClient.class.getPackage().getImplementationVersion());
        }
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(this.userAgents.entrySet());
        StringBuilder sb = new StringBuilder();
        for (int i = entryList.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            sb.append((String)entry.getKey()).append("/").append((String)entry.getValue());
            if (i <= 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public long getResponseTimeoutInSeconds() {
        return this.httpClientOptions.getMaxTimeMS();
    }

    public ApiResponseHttp post(String url, String token, String body) {
        return this.executeHttp("POST", url, token, body, CONTENT_TYPE_JSON);
    }

    public HttpRequest builtHttpRequest(String method, String url, String token, String body, String contentType) {
        try {
            return HttpRequest.newBuilder().uri(new URI(url)).header(HEADER_CONTENT_TYPE, contentType).header(HEADER_ACCEPT, CONTENT_TYPE_JSON).header(HEADER_USER_AGENT, this.getUserAgentHeader()).header(HEADER_REQUESTED_WITH, this.getUserAgentHeader()).header(HEADER_REQUEST_ID, UUID.randomUUID().toString()).header(HEADER_CASSANDRA, token).header(HEADER_AUTHORIZATION, "Bearer " + token).timeout(Duration.ofSeconds(this.httpClientOptions.getMaxTimeMS())).method(method, HttpRequest.BodyPublishers.ofString(body)).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL '" + url + "'", e);
        }
    }

    public ApiResponseHttp parseHttpResponse(HttpResponse<String> response) {
        ApiResponseHttp res = new ApiResponseHttp(response.body(), response.statusCode(), response.headers().map().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toString())));
        if (res.getCode() >= 300) {
            log.error("Error for request url={}, method={}, code={}, body={}", new Object[]{response.request().uri().toString(), response.request().method(), res.getCode(), res.getBody()});
            this.processErrors(res);
        }
        return res;
    }

    public ApiResponseHttp executeHttp(String method, String url, String token, String body, String contentType) {
        HttpRequest httpRequest = this.builtHttpRequest(method, url, token, body, contentType);
        Status<HttpResponse<String>> status = this.executeHttpRequest(httpRequest);
        return this.parseHttpResponse((HttpResponse)status.getResult());
    }

    public Status<HttpResponse<String>> executeHttpRequest(HttpRequest req) {
        Callable<HttpResponse> executeRequest = () -> this.httpClient.send(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        return new CallExecutorBuilder().config(this.retryConfig).onFailureListener(s -> log.error("Calls failed after {} retries", (Object)s.getTotalTries())).afterFailedTryListener(s -> {
            log.error("Failure on attempt {}/{} ", (Object)s.getTotalTries(), (Object)this.retryConfig.getMaxNumberOfTries());
            log.error("Failed request {} on {}", (Object)req.method(), (Object)req.uri().toString());
            log.error("+ Exception was ", (Throwable)s.getLastExceptionThatCausedRetry());
        }).build().execute(executeRequest);
    }

    private void processErrors(ApiResponseHttp res) {
        switch (res.getCode()) {
            case 401: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_UNAUTHORIZED) Invalid Credentials Check your token: " + res.getBody());
            }
            case 422: {
                throw new IllegalArgumentException("Error Code=" + res.getCode() + "(422) Invalid information provided to create DB: " + res.getBody());
            }
        }
        if (res.getCode() == 503) {
            throw new IllegalStateException(res.getBody() + " (http:" + res.getCode() + ")");
        }
        throw new DataApiException("CLIENT_HTTP", res.getBody() + " (http:" + res.getCode() + ")");
    }
}

