/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Instant;

public class CustomEJsonInstantDeserializer
extends JsonDeserializer<Instant> {
    public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (null == node.get("$date")) {
            throw new IllegalArgumentException("Cannot convert the expression as an Instant " + String.valueOf(node));
        }
        long timestamp = node.get("$date").asLong();
        return Instant.ofEpochMilli(timestamp);
    }
}

