/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.UUID;

public class CustomUuidDeserializer
extends JsonDeserializer<UUID> {
    public UUID deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (null == node.get("$uuid")) {
            throw new IllegalArgumentException("Cannot convert the expression as an UUID " + String.valueOf(node));
        }
        return UUID.fromString(node.get("$uuid").asText());
    }
}

