/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.utils;

import com.datastax.astra.client.exception.DataApiException;
import com.datastax.astra.client.model.ObjectId;
import com.datastax.astra.client.model.UUIDv6;
import com.datastax.astra.client.model.UUIDv7;
import com.datastax.astra.internal.utils.CustomEJsonCalendarDeserializer;
import com.datastax.astra.internal.utils.CustomEJsonCalendarSerializer;
import com.datastax.astra.internal.utils.CustomEJsonDateDeserializer;
import com.datastax.astra.internal.utils.CustomEJsonDateSerializer;
import com.datastax.astra.internal.utils.CustomEJsonInstantDeserializer;
import com.datastax.astra.internal.utils.CustomEJsonInstantSerializer;
import com.datastax.astra.internal.utils.CustomObjectIdDeserializer;
import com.datastax.astra.internal.utils.CustomObjectIdSerializer;
import com.datastax.astra.internal.utils.CustomUuidDeserializer;
import com.datastax.astra.internal.utils.CustomUuidSerializer;
import com.datastax.astra.internal.utils.CustomUuidv6Serializer;
import com.datastax.astra.internal.utils.CustomUuidv7Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;

public class JsonUtils {
    private static ObjectMapper dataApiObjectMapper;

    public static synchronized ObjectMapper getDataApiObjectMapper() {
        if (dataApiObjectMapper == null) {
            JsonFactory jsonFactory = JsonFactory.builder().enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER).enable(StreamReadFeature.USE_FAST_DOUBLE_PARSER).enable(StreamWriteFeature.USE_FAST_DOUBLE_WRITER).build();
            dataApiObjectMapper = new ObjectMapper(jsonFactory).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).setDateFormat((DateFormat)new SimpleDateFormat("dd/MM/yyyy")).setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
            SimpleModule module = new SimpleModule();
            module.addSerializer(Date.class, (JsonSerializer)new CustomEJsonDateSerializer());
            module.addDeserializer(Date.class, (JsonDeserializer)new CustomEJsonDateDeserializer());
            module.addSerializer(Calendar.class, (JsonSerializer)new CustomEJsonCalendarSerializer());
            module.addDeserializer(Calendar.class, (JsonDeserializer)new CustomEJsonCalendarDeserializer());
            module.addSerializer(Instant.class, (JsonSerializer)new CustomEJsonInstantSerializer());
            module.addDeserializer(Instant.class, (JsonDeserializer)new CustomEJsonInstantDeserializer());
            module.addSerializer(UUID.class, (JsonSerializer)new CustomUuidSerializer());
            module.addDeserializer(UUID.class, (JsonDeserializer)new CustomUuidDeserializer());
            module.addSerializer(UUIDv6.class, (JsonSerializer)new CustomUuidv6Serializer());
            module.addSerializer(UUIDv7.class, (JsonSerializer)new CustomUuidv7Serializer());
            module.addSerializer(ObjectId.class, (JsonSerializer)new CustomObjectIdSerializer());
            module.addDeserializer(ObjectId.class, (JsonDeserializer)new CustomObjectIdDeserializer());
            dataApiObjectMapper.registerModule((Module)module);
        }
        return dataApiObjectMapper;
    }

    private JsonUtils() {
    }

    public static String marshall(Object o) {
        Objects.requireNonNull(o);
        try {
            if (o instanceof String) {
                return (String)o;
            }
            return JsonUtils.getDataApiObjectMapper().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new DataApiException("CLIENT_SERIALIZATION", "Cannot marshall object " + String.valueOf(o), e);
        }
    }

    public static <T> T convertValue(Object bean, Class<T> clazz) {
        if (bean == null) {
            return null;
        }
        if (bean.getClass() == clazz) {
            return (T)bean;
        }
        return (T)JsonUtils.getDataApiObjectMapper().convertValue(bean, clazz);
    }

    public static <T> T unMarshallBean(String body, Class<T> ref) {
        try {
            return (T)JsonUtils.getDataApiObjectMapper().readValue(body, ref);
        }
        catch (JsonProcessingException e) {
            throw new DataApiException("CLIENT_SERIALIZATION", "Cannot unmarshall object " + body, e);
        }
    }
}

