/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.internal.utils;

import com.datastax.astra.client.model.DataAPIKeywords;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.Projection;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.internal.utils.Assert;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class OptionsUtils {
    private OptionsUtils() {
    }

    public static Document sort(Sort ... pSort) {
        Assert.notNull(pSort, "sort");
        Document finalSort = new Document();
        Arrays.stream(pSort).forEach(p -> finalSort.append(p.getField(), p.getOrder().getCode()));
        return finalSort;
    }

    public static Map<String, Object> projection(Projection ... pProjections) {
        Assert.notNull(pProjections, "sort");
        LinkedHashMap<String, Object> finalProjection = new LinkedHashMap<String, Object>();
        for (Projection p : pProjections) {
            if (p.getPresent() != null && p.getSliceStart() != null) {
                throw new IllegalArgumentException("A projection cannot be include/exclude and a slide at same time");
            }
            if (p.getPresent() == null && p.getSliceStart() == null) {
                throw new IllegalArgumentException("A projection must be include/exclude or a slide");
            }
            if (p.getPresent() != null) {
                finalProjection.put(p.getField(), p.getPresent() != false ? 1 : 0);
                continue;
            }
            int start = p.getSliceStart();
            LinkedHashMap<String, Object> slice = new LinkedHashMap<String, Object>();
            if (p.getSliceEnd() != null) {
                slice.put(DataAPIKeywords.SLICE.getKeyword(), new Integer[]{start, p.getSliceEnd()});
            } else {
                slice.put(DataAPIKeywords.SLICE.getKeyword(), start);
            }
            finalProjection.put(p.getField(), slice);
        }
        return finalProjection;
    }
}

