/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DbOpsClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.telemetry.CloudWatchTelemetryRequest;
import com.dtsx.astra.sdk.db.domain.telemetry.DatadogTelemetryRequest;
import com.dtsx.astra.sdk.db.domain.telemetry.KafkaTelemetryRequest;
import com.dtsx.astra.sdk.db.domain.telemetry.PrometheusTelemetryRequest;
import com.dtsx.astra.sdk.db.domain.telemetry.SpecializedTelemetryClient;
import com.dtsx.astra.sdk.db.domain.telemetry.SplunkTelemetryRequest;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;

public class DbTelemetryClient
extends AbstractApiClient {
    private final Database db;

    public DbTelemetryClient(String token, String databaseId) {
        this(token, AstraEnvironment.PROD, databaseId);
    }

    public DbTelemetryClient(String token, AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.db = new DbOpsClient(token, env, databaseId).get();
    }

    @Override
    public String getServiceName() {
        return "db.telemetry";
    }

    public ApiResponseHttp find() {
        return this.GET(this.getEndpointTelemetry(), this.getOperationName("find"));
    }

    public SpecializedTelemetryClient<KafkaTelemetryRequest> kafka() {
        return new SpecializedTelemetryClient<KafkaTelemetryRequest>(this.token, this.getEndpointTelemetry(), "kafka");
    }

    public SpecializedTelemetryClient<CloudWatchTelemetryRequest> cloudWatch() {
        return new SpecializedTelemetryClient<CloudWatchTelemetryRequest>(this.token, this.getEndpointTelemetry(), "cloudwatch");
    }

    public SpecializedTelemetryClient<PrometheusTelemetryRequest> prometheus() {
        return new SpecializedTelemetryClient<PrometheusTelemetryRequest>(this.token, this.getEndpointTelemetry(), "prometheus_remote");
    }

    public SpecializedTelemetryClient<DatadogTelemetryRequest> datadog() {
        return new SpecializedTelemetryClient<DatadogTelemetryRequest>(this.token, this.getEndpointTelemetry(), "Datadog");
    }

    public SpecializedTelemetryClient<SplunkTelemetryRequest> splunk() {
        return new SpecializedTelemetryClient<SplunkTelemetryRequest>(this.token, this.getEndpointTelemetry(), "splunk");
    }

    public String getEndpointTelemetry() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases/" + this.db.getId() + "/telemetry/metrics";
    }
}

