/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db.domain;

import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;

public class DatabaseCreationBuilder {
    public static final String DEFAULT_REGION = "us-east1";
    public static final String DEFAULT_TIER = "serverless";
    public static final CloudProviderType DEFAULT_CLOUD = CloudProviderType.GCP;
    protected CloudProviderType cloudProvider = DEFAULT_CLOUD;
    protected String region = "us-east1";
    protected String tier = "serverless";
    protected String name;
    protected String keyspace;
    protected boolean vector = false;
    protected int capacityUnits = 1;

    public DatabaseCreationBuilder name(String name) {
        this.name = name;
        return this;
    }

    public DatabaseCreationBuilder keyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public DatabaseCreationBuilder cloudProvider(CloudProviderType cloudProvider) {
        this.cloudProvider = cloudProvider;
        return this;
    }

    public DatabaseCreationBuilder tier(String tier) {
        this.tier = tier;
        return this;
    }

    public DatabaseCreationBuilder cloudRegion(String region) {
        this.region = region;
        return this;
    }

    public DatabaseCreationBuilder capacityUnit(int unit) {
        this.capacityUnits = unit;
        return this;
    }

    public DatabaseCreationBuilder withVector() {
        this.vector = true;
        return this;
    }

    public DatabaseCreationRequest build() {
        return new DatabaseCreationRequest(this);
    }
}

