/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils.observability;

import com.dtsx.astra.sdk.utils.JsonUtils;
import com.dtsx.astra.sdk.utils.observability.AnsiUtils;
import com.dtsx.astra.sdk.utils.observability.ApiExecutionInfos;
import com.dtsx.astra.sdk.utils.observability.ApiRequestObserver;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingRequestObserver
implements ApiRequestObserver {
    private final Logger logger;
    private final Level logLevel;

    public LoggingRequestObserver(Class<?> sourceClass) {
        this(Level.DEBUG, sourceClass);
    }

    public LoggingRequestObserver(Level logLevel, Class<?> sourceClass) {
        this.logLevel = logLevel;
        this.logger = LoggerFactory.getLogger(sourceClass);
    }

    @Override
    public void onRequest(ApiExecutionInfos executionInfo) {
        if (executionInfo != null) {
            String req = UUID.randomUUID().toString().substring(30);
            this.log("Devops API [" + AnsiUtils.cyan(executionInfo.getOperationName()) + "] with id [" + AnsiUtils.cyan(req) + "]", new Object[0]);
            this.log(AnsiUtils.magenta("[" + req + "][url]") + "=" + AnsiUtils.yellow("{}"), executionInfo.getRequestUrl());
            this.log(AnsiUtils.magenta("[" + req + "][response-time]") + "=" + AnsiUtils.yellow("{}") + " millis.", executionInfo.getExecutionTime());
            if (executionInfo.getRequest() != null) {
                try {
                    this.log(AnsiUtils.magenta("[" + req + "][request]") + "=" + AnsiUtils.yellow("{}"), JsonUtils.marshall(executionInfo.getRequest()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.log(AnsiUtils.magenta("[" + req + "][response-code]") + "=" + AnsiUtils.yellow("{}"), executionInfo.getResponseHttpCode());
            if (executionInfo.getResponseBody() != null) {
                try {
                    this.log(AnsiUtils.magenta("[" + req + "][response-body]") + "=" + AnsiUtils.yellow("{}"), JsonUtils.marshall(executionInfo.getResponseBody()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void log(String message, Object ... params) {
        switch (this.logLevel) {
            case TRACE: {
                this.logger.trace(message, params);
                break;
            }
            case DEBUG: {
                this.logger.debug(message, params);
                break;
            }
            case INFO: {
                this.logger.info(message, params);
                break;
            }
            case WARN: {
                this.logger.warn(message, params);
                break;
            }
            case ERROR: {
                this.logger.error(message, params);
            }
        }
    }
}

