/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.org;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.org.domain.CreateRoleResponse;
import com.dtsx.astra.sdk.org.domain.DefaultRoles;
import com.dtsx.astra.sdk.org.domain.Role;
import com.dtsx.astra.sdk.org.domain.RoleDefinition;
import com.dtsx.astra.sdk.org.exception.RoleNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class RolesClient
extends AbstractApiClient {
    public static final String PATH_ORGANIZATIONS = "/organizations";
    public static final String PATH_ROLES = "/roles";
    public static final TypeReference<List<Role>> TYPE_LIST_ROLES = new TypeReference<List<Role>>(){};

    public RolesClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public RolesClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    @Override
    public String getServiceName() {
        return "roles";
    }

    public Stream<Role> findAll() {
        ApiResponseHttp res = this.GET(this.getApiEndpointRoles(), this.getOperationName("findAll"));
        return JsonUtils.unmarshallType(res.getBody(), TYPE_LIST_ROLES).stream();
    }

    public Optional<Role> find(String roleId) {
        ApiResponseHttp res = this.GET(this.getEndpointRole(roleId), this.getOperationName("find"));
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of(JsonUtils.unmarshallBean(res.getBody(), Role.class));
    }

    public Role get(String roleId) {
        return this.find(roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
    }

    public Optional<Role> find(DefaultRoles role) {
        return this.findByName(role.getName());
    }

    public Role get(DefaultRoles role) {
        return this.find(role).orElseThrow(() -> new RoleNotFoundException(role.getName()));
    }

    public Optional<Role> findByName(String roleName) {
        Assert.hasLength(roleName, "User email should not be null nor empty");
        return this.findAll().filter(r -> r.getName().equalsIgnoreCase(roleName)).findFirst();
    }

    public Role getByName(String roleName) {
        return this.findByName(roleName).orElseThrow(() -> new RoleNotFoundException(roleName));
    }

    public CreateRoleResponse create(RoleDefinition cr) {
        Assert.notNull(cr, "CreateRole request");
        ApiResponseHttp res = this.POST(this.getApiEndpointRoles(), JsonUtils.marshall(cr), this.getOperationName("create"));
        return JsonUtils.unmarshallBean(res.getBody(), CreateRoleResponse.class);
    }

    public boolean exist(String roleId) {
        return this.find(roleId).isPresent();
    }

    public void delete(String roleId) {
        this.get(roleId);
        this.DELETE(this.getEndpointRole(roleId), this.getOperationName("delete"));
    }

    public void update(String roleId, RoleDefinition cr) {
        this.PUT(this.getEndpointRole(roleId), JsonUtils.marshall(cr), this.getOperationName("update"));
    }

    private String getApiEndpointRoles() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/organizations/roles";
    }

    private String getEndpointRole(String role) {
        return this.getApiEndpointRoles() + "/" + role;
    }
}

