/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.org.domain;

import com.dtsx.astra.sdk.org.domain.Permission;
import com.dtsx.astra.sdk.org.domain.RolePolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RoleDefinition {
    private String name;
    private final RolePolicy policy;

    public static RoleDefinitionBuilder builder(String orgId) {
        return new RoleDefinitionBuilder(orgId);
    }

    private RoleDefinition(RoleDefinitionBuilder builder) {
        this.name = builder.name;
        RolePolicy policy = new RolePolicy();
        policy.setEffect("allow");
        policy.setDescription(builder.description);
        policy.setActions(builder.permissions.stream().map(Permission::getCode).collect(Collectors.toList()));
        policy.setResources(builder.resources);
        this.policy = policy;
    }

    public String getName() {
        return this.name;
    }

    public RolePolicy getPolicy() {
        return this.policy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class RoleDefinitionBuilder {
        private static final String RSC_PREFIX = "drn:astra:org:";
        private String name;
        private String description;
        private String organizationId;
        private List<Permission> permissions = new ArrayList<Permission>();
        private List<String> resources = new ArrayList<String>();

        public RoleDefinitionBuilder(String orgId) {
            this.organizationId = orgId;
            this.resources.add(RSC_PREFIX + this.organizationId);
        }

        public RoleDefinitionBuilder organizationId(String o) {
            this.organizationId = o;
            return this;
        }

        public RoleDefinitionBuilder name(String n) {
            this.name = n;
            return this;
        }

        public RoleDefinitionBuilder description(String n) {
            this.description = n;
            return this;
        }

        public RoleDefinitionBuilder addPermision(Permission p) {
            this.permissions.add(p);
            return this;
        }

        public RoleDefinitionBuilder addResourceDatabase(String dbName) {
            this.resources.add(RSC_PREFIX + this.organizationId + ":db:" + dbName);
            return this;
        }

        public RoleDefinitionBuilder addResourceAllDatabases() {
            return this.addResourceDatabase("*");
        }

        public RoleDefinitionBuilder addResourceKeyspaceForDatabase(String dbName, String keyspace) {
            this.resources.add(RSC_PREFIX + this.organizationId + ":db:" + dbName + ":keyspace:" + keyspace);
            return this;
        }

        public RoleDefinitionBuilder addResourceAllKeyspaces() {
            return this.addResourceKeyspaceForDatabase("*", "*");
        }

        public RoleDefinitionBuilder addResourceAllKeyspacesForDatabase(String dbName) {
            return this.addResourceKeyspaceForDatabase(dbName, "*");
        }

        public RoleDefinitionBuilder addResourceTable(String dbName, String keyspace, String tableName) {
            this.resources.add(RSC_PREFIX + this.organizationId + ":db:" + dbName + ":keyspace:" + keyspace + ":table:" + tableName);
            return this;
        }

        public RoleDefinitionBuilder addResourceAllTablesKeyspaceForDatabase(String dbName, String keyspace) {
            return this.addResourceTable(dbName, keyspace, "*");
        }

        public RoleDefinitionBuilder addResourceAllTablesForDatabase(String dbName) {
            return this.addResourceTable(dbName, "*", "*");
        }

        public RoleDefinitionBuilder addResourceAllTables() {
            return this.addResourceTable("*", "*", "*");
        }

        public RoleDefinition build() {
            return new RoleDefinition(this);
        }
    }
}

