/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.exception.KeyspaceNotFoundException;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.streaming.domain.CdcDefinition;
import com.dtsx.astra.sdk.streaming.domain.CreateCdc;
import com.dtsx.astra.sdk.streaming.domain.DeleteCdc;
import com.dtsx.astra.sdk.streaming.domain.Tenant;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.HttpClientWrapper;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class TenantCdcClient
extends AbstractApiClient {
    private final Tenant tenant;

    public TenantCdcClient(String token, String tenantId) {
        this(token, AstraEnvironment.PROD, tenantId);
    }

    public TenantCdcClient(String token, AstraEnvironment env, String tenantId) {
        super(token, env);
        Assert.hasLength(tenantId, "tenantId");
        this.tenant = new AstraStreamingClient(token, this.environment).get(tenantId);
    }

    @Override
    public String getServiceName() {
        return "streaming.cdc";
    }

    public void create(String databaseId, String keyspace, String table, int topicPartition) {
        Assert.hasLength(keyspace, "keyspace");
        Assert.hasLength(table, "table");
        Assert.isTrue(topicPartition > 0, "topic partition should be positive");
        Database db = new AstraDBOpsClient(this.token, this.environment).database(databaseId).get();
        if (!db.getInfo().getKeyspaces().contains(keyspace)) {
            throw new KeyspaceNotFoundException(databaseId, keyspace);
        }
        CreateCdc createCdc = new CreateCdc();
        createCdc.setOrgId(db.getOrgId());
        createCdc.setDatabaseId(db.getId());
        createCdc.setDatabaseName(db.getInfo().getName());
        createCdc.setKeyspace(keyspace);
        createCdc.setTableName(table);
        createCdc.setTopicPartitions(topicPartition);
        HttpClientWrapper.getInstance(this.getOperationName("create")).POST_PULSAR(this.getEndpointTenantCdc(), this.tenant.getPulsarToken(), JsonUtils.marshall(createCdc), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString());
    }

    public void delete(String databaseId, String keyspace, String table) {
        Assert.hasLength(keyspace, "keyspace");
        Assert.hasLength(table, "table");
        Database db = new AstraDBOpsClient(this.token, this.environment).database(databaseId).get();
        DeleteCdc deleteCdc = new DeleteCdc();
        deleteCdc.setOrgId(db.getOrgId());
        deleteCdc.setDatabaseId(db.getId());
        deleteCdc.setKeyspace(keyspace);
        deleteCdc.setTableName(table);
        HttpClientWrapper.getInstance(this.getOperationName("delete")).DELETE_PULSAR(this.getEndpointTenantCdc(), this.tenant.getPulsarToken(), JsonUtils.marshall(deleteCdc), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString());
    }

    public Stream<CdcDefinition> list() {
        ApiResponseHttp res = HttpClientWrapper.getInstance(this.getOperationName("list")).GET_PULSAR(this.getEndpointTenantCdc(), this.tenant.getPulsarToken(), this.tenant.getClusterName(), this.tenant.getOrganizationId().toString());
        return JsonUtils.unmarshallType(res.getBody(), new TypeReference<List<CdcDefinition>>(){}).stream();
    }

    public Optional<CdcDefinition> findCdcById(String cdcId) {
        Assert.hasLength(cdcId, "cdc identifier");
        return this.list().filter(cdc -> cdc.getConnectorName().equals(cdcId)).findFirst();
    }

    public Optional<CdcDefinition> findCdcByDefinition(String keyspace, String table, String databaseIdentifier) {
        Assert.hasLength(keyspace, "keyspace");
        Assert.hasLength(table, "table");
        return this.list().filter(cdc -> cdc.getKeyspace().equals(keyspace) && cdc.getDatabaseTable().equals(table) && cdc.getDatabaseId().equals(databaseIdentifier)).findFirst();
    }

    public String getEndpointTenantCdc() {
        return ApiLocator.getApiStreamingV3Endpoint(this.environment, this.tenant.getClusterName(), this.tenant.getTenantName()) + "/cdc";
    }
}

