/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;

public class Utils {
    private Utils() {
    }

    public static boolean hasLength(String str) {
        return null != str && !"".equals(str);
    }

    public static boolean hasAllLength(String ... lStr) {
        if (null == lStr) {
            return false;
        }
        return Arrays.stream(lStr).allMatch(Utils::hasLength);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] downloadFile(String fileUrl) {
        try {
            URL url = new URL(fileUrl);
            try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Cannot download file", ioe);
        }
    }

    public static void downloadFile(String urlStr, String file) {
        FileOutputStream fis = null;
        BufferedInputStream bis = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Accept", "bytes");
            bis = new BufferedInputStream(urlConnection.getInputStream());
            fis = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = bis.read(buffer, 0, 1024)) != -1) {
                fis.write(buffer, 0, count);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot read URL, invalid syntax", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot download file", e);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != bis) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Optional<String> readEnvVariable(String key) {
        if (Utils.hasLength(System.getProperty(key))) {
            return Optional.ofNullable(System.getProperty(key));
        }
        if (Utils.hasLength(System.getenv(key))) {
            return Optional.ofNullable(System.getenv(key));
        }
        return Optional.empty();
    }
}

