/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.HttpClientWrapper;
import com.dtsx.astra.sdk.utils.observability.ApiRequestObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractApiClient {
    protected final String token;
    protected final AstraEnvironment environment;
    protected final Map<String, ApiRequestObserver> observers = new LinkedHashMap<String, ApiRequestObserver>();

    public AbstractApiClient(String token, AstraEnvironment env) {
        Assert.hasLength(token, "token");
        this.token = token;
        this.environment = env;
    }

    public AbstractApiClient(String token, AstraEnvironment env, Map<String, ApiRequestObserver> observers) {
        Assert.hasLength(token, "token");
        this.token = token;
        this.environment = env;
        this.observers.putAll(observers);
    }

    public HttpClientWrapper getHttpClient(String operation) {
        return HttpClientWrapper.getInstance(operation);
    }

    public abstract String getServiceName();

    protected String getOperationName(String operation) {
        return this.getServiceName() + "." + operation;
    }

    public ApiResponseHttp GET(String url, String operation) {
        return this.getHttpClient(operation).GET(url, this.getToken());
    }

    public ApiResponseHttp HEAD(String url, String operation) {
        return this.getHttpClient(operation).HEAD(url, this.getToken());
    }

    public ApiResponseHttp POST(String url, String operation) {
        return this.getHttpClient(operation).POST(url, this.getToken());
    }

    public ApiResponseHttp POST(String url, String body, String operation) {
        return this.getHttpClient(operation).POST(url, this.getToken(), body);
    }

    public void PUT(String url, String body, String operation) {
        this.getHttpClient(operation).PUT(url, this.getToken(), body);
    }

    public void PATCH(String url, String body, String operation) {
        this.getHttpClient(operation).PATCH(url, this.getToken(), body);
    }

    public void DELETE(String url, String operation) {
        this.getHttpClient(operation).DELETE(url, this.getToken());
    }

    public void assertHttpCodeAccepted(ApiResponseHttp res, String action, String entityId) {
        String errorMsg = " Cannot " + action + " id=" + entityId + " code=" + res.getCode() + " msg=" + res.getBody();
        Assert.isTrue(202 == res.getCode(), errorMsg);
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public AstraEnvironment getEnvironment() {
        return this.environment;
    }

    @Generated
    public Map<String, ApiRequestObserver> getObservers() {
        return this.observers;
    }
}

