/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.org.KeysClient;
import com.dtsx.astra.sdk.org.RolesClient;
import com.dtsx.astra.sdk.org.TokensClient;
import com.dtsx.astra.sdk.org.UsersClient;
import com.dtsx.astra.sdk.org.domain.Organization;
import com.dtsx.astra.sdk.org.domain.ResponseAllUsers;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.Map;

public class AstraOpsClient
extends AbstractApiClient {
    public AstraOpsClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public AstraOpsClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    @Override
    public String getServiceName() {
        return "ops";
    }

    public String getOrganizationId() {
        ApiResponseHttp res = this.GET(ApiLocator.getApiDevopsEndpoint(this.environment) + "/currentOrg", this.getOperationName("orgId"));
        return (String)JsonUtils.unmarshallBean(res.getBody(), Map.class).get("id");
    }

    public Organization getOrganization() {
        ApiResponseHttp res = this.GET(this.users().getEndpointUsers(), this.getOperationName("org"));
        ResponseAllUsers body = JsonUtils.unmarshallBean(res.getBody(), ResponseAllUsers.class);
        return new Organization(body.getOrgId(), body.getOrgName());
    }

    public AstraDBOpsClient db() {
        return new AstraDBOpsClient(this.token, this.environment);
    }

    public AstraStreamingClient streaming() {
        return new AstraStreamingClient(this.token, this.environment);
    }

    public UsersClient users() {
        return new UsersClient(this.token, this.environment);
    }

    public RolesClient roles() {
        return new RolesClient(this.token, this.environment);
    }

    public KeysClient keys() {
        return new KeysClient(this.token, this.environment);
    }

    public TokensClient tokens() {
        return new TokensClient(this.token, this.environment);
    }
}

